/*
 *  kinugasa.c
 *      LkKT Le
 *      written by H.Tsujimura    8 Oct 2004 / 2 Oct 2006
 *
 * History:
 * $Log: /makeRSS/cocousagi/kinugasa.c $
 * 
 * 3     08/09/09 21:42 Tsujimura543
 * loginKinugasa()  postKinugasa()  xmlRPC.dll ڊ
 * 
 * 2     06/10/02 20:08 Tsujimura543
 * cocousagi.h CN[h悤ɂ
 * 
 * 1     06/10/02 19:17 Tsujimura543
 * cocousagi.c  LkKT L̏𕪗
 */

#ifdef  WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "xmlRPC.h"
#include "cocousagi.h"

/*
 * LkKTe
 */

int
loginKinugasa( const char *username,// (I) LkKT ID ([AhX)
               const char *password,// (I) pX[h
               char       *cookie ) // (O) NbL[
{
    int     ret = 0;
    char    *request;
    char    *response;
    char    url[MAX_URLLENGTH];
    size_t  sz = MAX_CONTENT_SIZE;

    if ( !username || !(*username) ||
         !password || !(*password) ||
         !cookie )
         return ( ret );

 // if ( !username )
 //     username = xmlrpc_p->userName;
 // if ( !password )
 //     password = xmlrpc_p->password;

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !response ) {
        free( request );
        return ( ret );
    }
    memset( request, 0x00, MAX_CONTENT_SIZE );

    strcpy( url, "http://kinugasa.cc/login.php?url=%2F" );
    setTargetURL( url );
    sprintf( request,
             "url=%s&"
             "username=%s&"
             "password=%s&"
             "auto_login=1",
             "/index.php",
             username, password );
    setUpReceiveBuffer( response, sz );
 // ret = httpPostWithSession( xmlrpc_p->webServer, xmlrpc_p->webPage,
 //                            "application/x-www-form-urlencoded",
 //                            request, response, cookie,
 //                            NULL, NULL );
    http_postEx( url, "application/x-www-form-urlencoded",
                 request, response, cookie );
 // if ( ret == -1 )
 //     ret = 0;        /* T[oƂ̒ʐMs */
 // else
    if ( *response ) {
     // if ( strstr( response, "./profile.php?key=" ) != NULL )
        if ( strstr( response, "./icon.php?key=" ) != NULL )
            ret = 1;    /* OC */
        else
            ret = 0;    /* OCs */
    }

    free( response );
    free( request  );

    return ( ret );
}

int
postKinugasa( const char *username, // (I) LkKT ID ([AhX)
              const char *password, // (I) pX[h
              char       *cookie,   // (I/O) NbL[
              const char *title,    // (I) L薼
              const char *body )    // (I) L{
{
    int         ret = 0;
    char        *request;
    char        *response;
    char        url[MAX_URLLENGTH];
    time_t      t = time( NULL );
    struct tm   *tm = localtime( &t );
    int         yy, mm, dd, HH, MM, SS;
    size_t      sz = MAX_CONTENT_SIZE * 2;

    if ( !username || !(*username) ||
         !password || !(*password) ||
         !title    || !(*title)    ||
         !body     || !(*body)     ||
         !cookie   || !(*cookie)      )
         return ( ret );

 // if ( !username )
 //     username = xmlrpc_p->userName;
 // if ( !password )
 //     password = xmlrpc_p->password;

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }
    memset( request, 0x00, MAX_CONTENT_SIZE );

    /* e */
    yy = tm->tm_year + 1900;
    mm = tm->tm_mon + 1;
    dd = tm->tm_mday;
    HH = tm->tm_hour;
    MM = tm->tm_min;
    SS = tm->tm_sec;
    strcpy( url, "http://kinugasa.cc/diary_add.php" );
    setTargetURL( url );
    sprintf( request,
             "diary_title=%s&"
             "diary_view_policy=1&"
             "diary_comment_policy=1&"
             "diary_link_policy=1&"
          // "diary_datetime=%04d-%02d-%02d+%02d%%3A%02d%%3A%02d&"
             "diary_datetime=%04d-%02d-%02d %02d:%02d:%02d&"
             "diary_text=%s",
             title, yy, mm, dd, HH, MM, SS, body );
    setUpReceiveBuffer( response, sz );
 // ret = httpPostWithSession( xmlrpc_p->webServer, xmlrpc_p->webPage,
 //                            "application/x-www-form-urlencoded",
 //                            request, response, cookie,
 //                            NULL, NULL );
    http_postEx( url, "application/x-www-form-urlencoded",
                 request, response, cookie );
    if ( *response )
        ret = 1;

    free( response );
    free( request  );

    return ( ret == -1 ? 0 : 1 );
}


int
postArticleOnKinugasa( const char *username,/* LkKT ID ([AhX) */
                       const char *password,/* pX[h                   */
                       char *title,             /* eL薼 */
                       char *body,              /* eL{ */
                       int  forceWritingForPet )    /* M */
{
    int     ret     = 0;
    char    *cookie = (char *)malloc( MAX_COOKIE_LEN );

    if ( cookie ) {
        memset( cookie, 0x00, MAX_COOKIE_LEN );
        if ( loginKinugasa( username, password, cookie ) ) {
            char    *s, *t;
            char    *temp = (char *)malloc( strlen( title ) + 16 );

            if ( temp ) {
                strcpy( temp, sjis2utf("[e] ") );
                strcat( temp, title );
                strcpy( title, temp );
                free( temp );
            }
            s = utf2euc( title );
            strcpy( title, s );
            if ( !forceWritingForPet )
                strcat( title, sjis2euc( " [via cocousagi]" ) );
            else {
                time_t      t = time( NULL );
                struct tm   *tm = localtime( &t );

                sprintf( title + strlen( title ),
                         " (%04d/%02d/%02d)",
                         tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
            }
            s = encodeURL( title );
            strcpy( title, s );
            t = editForMixi( body );/* mixi p̏𗬗p */
            strcpy( body, encodeURL( sjis2euc( t ) ) );

            ret = postKinugasa( username, password, cookie,
                                title, body );
        }

        free( cookie );
    }
    else
        fprintf( stderr, "login Ɏs܂B\n" );

    return ( ret );
}
