/*
 *  openPNE.c
 *      OpenPNE Le
 *      written by H.Tsujimura    15 Sep 2006 / 2 Oct 2006
 *
 * History:
 * $Log: /makeRSS/cocousagi/openPNE.c $
 * 
 * 4     09/04/21 19:04 Tsujimura543
 * OpenPNE ̐VłɂΉ
 * 
 * 3     07/12/05 23:34 Tsujimura543
 * makeMultiPartItem() ̈ǉɔC{
 * 
 * 2     06/10/02 20:08 Tsujimura543
 * cocousagi.h CN[h悤ɂ
 * 
 * 1     06/10/02 18:27 Tsujimura543
 * cocousagi.c  OpenPNE L̏𕪗
 */

#ifdef  WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "xmlRPC.h"
#include "multipart.h"
#include "cocousagi.h"


/*
 *  OpenPNE e
 */

BOOL
loginOpenPNE( const char *username, const char *password, char *cookie )
{
    BOOL    ret = FALSE;
    char    request[BUFSIZ];
    char    *response;
    size_t  sz = MAX_CONTENT_SIZE;

    response = (char *)malloc( sz );
    if ( !response )
        return ( ret );
    sprintf( request,
             "m=pc&"
             "a=do_o_login&"
             "username=%s&"
             "password=%s&"
             "is_save=1",
             username, password );
    setUpReceiveBuffer( response, sz );
    http_postEx( "http://openpne.jp/", "application/x-www-form-urlencoded",
                 request, response, cookie );
    if ( *response ) {
        if ( strstr( response, "a=do_inc_page_header_logout" ) )
            ret = TRUE; // OC
    }
    free( response );

    return ( ret );
}

int
postOpenPNE( const char *title, const char *body, char *cookie )
{
    int     ret = 0;
    char    url[MAX_URLLENGTH];
    char    *request;
    char    *response;
    size_t  sz = MAX_CONTENT_SIZE;
    char    dummy[4096];
    char    sessid[64];
    char    maxFileSize[20];
    char    contentType[128];
    char    *separator = getMultiPartID();

    sessid[0]      = NUL;
    maxFileSize[0] = NUL;
    request = (char *)malloc( sz );
    if ( !request )
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }

    // http://openpne.jp/?m=pc&a=page_h_diary_add  GET
    Sleep( 1000 );
    strcpy( url, "http://openpne.jp/?m=pc&a=page_h_diary_add" );
    setUpReceiveBuffer( response, sz );
    http_getEx( url, response, cookie );
    if ( *response ) {
        //  -- MAX_FILE_SIZE 擾
        char    *p, *q;

        p = strstr( response, "name=\"MAX_FILE_SIZE\" value=\"" );
        if ( p ) {
            p += 28;
            q = strchr( p, '"' );
            if ( q ) {
                strncpy( maxFileSize, p, q - p );
                maxFileSize[q - p] = NUL;
            }
        }
    }

    // e
    Sleep( 1000 );
    sprintf( contentType, "multipart/form-data; boundary=%s", separator );
    strcpy( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                               "m", 0, "pc", NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                               "a", 0, "page_h_diary_add_confirm", NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                               "MAX_FILE_SIZE", 0,
                               maxFileSize[0] ? maxFileSize // OpenPNE 2
                                              : "307200",   // OpenPNE 1
                               NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                               "subject", 0, title, NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                               "body", 0, body, NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_FILE,
                               "upfile_1", 0, NULL, NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_FILE,
                               "upfile_2", 0, NULL, NULL ) );
    strcat( request, 
            makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_FILE,
                               "upfile_3", 0, NULL, NULL ) );
    if ( maxFileSize[0] ) {
        strcat( request, 
                makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                                   "category", 0, "cocousagi", NULL ) ); // @@
        strcat( request, 
                makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                                   "public_flag", 0, "public", NULL ) ); // @@
        strcat( request, 
                makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                                   "qa_status", 0, "-1", NULL ) );       // @@
        strcat( request, 
                makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                                   "submit", 0,
                                   sjis2utf("mF"), NULL ) );
    }
    else
        strcat( request, 
                makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_STRING,
                                   "submit", 0,
                                   sjis2utf("@mFʁ@"), NULL ) );
    sprintf( request + strlen( request ), "--%s--\r\n", separator );
    makeMultiPartItem( separator, MULITIPART_ITEM_TYPE_BUFFERFREE,
                       NULL, 0, NULL, NULL ); // n
    sprintf( dummy, "%sReferer: %s\r\n", cookie, url );
    strcpy( url, "http://openpne.jp/" );
    setUpReceiveBuffer( response, sz );
    http_postEx( url, contentType,
                request, response, dummy );
    if ( *response ) {
        //  -- sessid 擾
        char    *p, *q;

        p = strstr( response, "name=\"sessid\" value=\"" );
        if ( p ) {
            p += 21;
            q = strchr( p, '"' );
            if ( q ) {
                strncpy( sessid, p, q - p );
                sessid[q - p] = NUL;
            }
        }
    }

    if ( sessid[0] ) {
        // emF
        Sleep( 1000 );
        if ( maxFileSize[0] )
            sprintf( request,
                     "m=pc&"
                     "a=do_h_diary_add_insert_c_diary&"
                     "sessid=%s&"
                     "subject=%s&"
                     "body=%s&"
                     "public_flag=public&"
                     "tmpfile_1=&"
                     "tmpfile_2=&"
                     "tmpfile_3=&"
                     "category=cocousagi&"
                     "qa_status=-1&"
                     "submit=%s",
                     sessid, title, body, sjis2utf("@@@") );
        else
            sprintf( request,
                     "m=pc&"
                     "a=do_h_diary_add_insert_c_diary&"
                     "sessid=%s&"
                     "subject=%s&"
                     "body=%s&"
                     "tmpfile_1=&"
                     "tmpfile_2=&"
                     "tmpfile_3=&"
                     "submit=%s",
                     sessid, title, body, sjis2utf("@ @@") );
        setUpReceiveBuffer( response, sz );
        http_postEx( url, "application/x-www-form-urlencoded",
                    request, response, cookie );

        if ( *response ) {
            if ( strstr( response, sjis2utf("FL{") ) )
                ret = 1; // e
        }
    }

    free( response );
    free( request );

    return ( ret );
}

int
postArticleOnOpenPNE( const char *username,     /* [U([AhX) */
                      const char *password,     /* pX[h               */
                      char *title,              /* eL薼             */
                      char *body,               /* eL{             */
                      int  forceWritingForPet ) /* 㗝e             */
{
    int     ret     = 0;
    char    *cookie = (char *)malloc( MAX_COOKIE_LEN );

    if ( cookie ) {
        memset( cookie, 0x00, MAX_COOKIE_LEN );
        if ( loginOpenPNE( username, password, cookie ) ) {
            char    *s, *t;

            if ( title[0] ) {
                char    *temp = (char *)malloc( strlen( title ) + 16 );

                if ( temp ) {
                    strcpy( temp, sjis2utf("[e] ") );
                    strcat( temp, title );
                    strcpy( title, temp );
                    free( temp );
                }

                if ( !forceWritingForPet )
                    strcat( title, " [via cocousagi]" );
                else {
                    time_t      t = time( NULL );
                    struct tm   *tm = localtime( &t );

                    sprintf( title + strlen( title ),
                             " (%04d/%02d/%02d)",
                             tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
                }
            }
            s = editForColors( body );  /* bI editForColors() 𗬗p */
            t = sjis2utf( s );
                /* OpenPNE ł͎gȂ^Oʂ̕\ɒu */
            strcpy( body, t ? t : s );

            ret = postOpenPNE( title, body, cookie );
        }

        free( cookie );
    }
    else
        fprintf( stderr, "login Ɏs܂B\n" );

    return ( ret );
}
