/*
 *  rakuten.c
 *      yVuOe
 *      written by H.Tsujimura    21 Apr 2005 / 2 Oct 2006
 *
 * History:
 * $Log: /makeRSS/cocousagi/rakuten.c $
 * 
 * 4     08/09/10 18:04 Tsujimura543
 * loginRakuten(), postRakuten()  xmlRPC.dll ڊ
 * 
 * 3     07/01/23 15:33 Tsujimura543
 * (1) yVuO̐VǗʂɑΉ
 * (2) yVuOɃJeSw肵ēeł悤ɂ
 * 
 * 2     06/10/02 20:08 Tsujimura543
 * cocousagi.h CN[h悤ɂ
 * 
 * 1     06/10/02 18:54 Tsujimura543
 * cocousagi.c  yVuO L̏𕪗
 */

#ifdef  WIN32
#include <time.h>
#else
#include <sys/time.h>
#endif

#include "xmlRPC.h"
#include "cocousagi.h"

/*
 * uyVLv߁uyVuOve
 */


/*  blog URL 擾 */
static char *
getBlogURL( char *url, const char *htmlSrc )
{
    const char  *p, *q;

    p = strstr( htmlSrc, sjis2euc("Myy[W̊mF") );
    if ( p ) {
        while ( p > htmlSrc ) {
            if ( *--p != 'h' )
                continue;
            if ( !strncmp( p, "href=\"http://plaza.rakuten.co.jp/", 33 ) ) {
                p += 6;
                q = strchr( p, '"' );
                if ( q ) {
                    strncpy( url, p, q - p );
                    url[q - p] = NUL;
                }
                break;
            }
        }
    }

    return ( url );
}

int
loginRakuten( const char *username,
              const char *password,
              char       *cookie,
              char       *myBlogURL )
{
    int     ret = 0;
    char    *request;
    char    *response;
    size_t  sz = MAX_CONTENT_SIZE;
    char    url[MAX_URLLENGTH];

    if ( !username || !(*username) ||
         !password || !(*password) ||
         !cookie )
         return ( ret );

 // if ( !username )
 //     username = xmlrpc_p->userName;
 // if ( !password )
 //     password = xmlrpc_p->password;

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }

    memset( request, 0x00, MAX_CONTENT_SIZE );
    strcpy( url,
     "https://grp02.id.rakuten.co.jp/rms/nid/vc?__event=login&service_id=59");
    setTargetURL( url );
    sprintf( request,
             "u=%s&"
             "p=%s&"
             "autologin=true",
             username, password );
    setUpReceiveBuffer( response, sz );
 // ret = httpPostWithSession( xmlrpc_p->webServer, xmlrpc_p->webPage,
 //                            "application/x-www-form-urlencoded",
 //                            request, response, cookie,
 //                            NULL, NULL );
    http_postEx( url, "application/x-www-form-urlencoded",
                 request, response, cookie );

 // if ( ret == -1 )
 //     ret = 0;        /* T[oƂ̒ʐMs */
 // else
    if ( *response ) {
        if ( strstr( response, "class=\"loginUser\"" ) &&
             strstr( response, "class=\"blogData\"" )     ) {
            ret = 1;    /* OC */
            getBlogURL( myBlogURL, response );
        }
        else
            ret = 0;    /* OCs */
    }

    free( response );
    free( request  );

    return ( ret );
}


int
postRakuten( const char *username,
             const char *password,
             char       *cookie,
             const char *categoryName,  /* JeS */
             const char *title,         /* 薼       */
             const char *body )         /* {       */
{
    int         ret = 0;
    char        *request;
    char        *response;
    size_t      sz = MAX_CONTENT_SIZE * 4;
    char        url[MAX_URLLENGTH];
    char        var_dummy[80];
    char        ch[80];
    int         yyyy, mm, dd;
    time_t      t;
    struct tm   *tm;
    int         categoryID = 0; /* ftHǵuJeSށv */

    if ( !username || !(*username) ||
         !password || !(*password) ||
         !title    || !(*title)    ||
         !body     || !(*body)     ||
         !cookie   || !(*cookie)      )
         return ( ret );

 // if ( !username )
 //     username = xmlrpc_p->userName;
 // if ( !password )
 //     password = xmlrpc_p->password;

    request  = (char *)malloc( MAX_CONTENT_SIZE );
    if ( !request ) 
        return ( ret );
    response = (char *)malloc( sz );
    if ( !response ) {
        free( request );
        return ( ret );
    }

    /* var_dummy 擾 */
    memset( request, 0x00, MAX_CONTENT_SIZE );
    var_dummy[0] = NUL;
    ch[0]        = NUL;
    strcpy( url, "http://my.plaza.rakuten.co.jp/?func=diary&act=write" );
    setUpReceiveBuffer( response, sz );
 // httpGetBufferWithSession( url, response, TRUE, NULL, NULL, cookie,
 //                           NULL, NULL );
    http_getEx( url, response, cookie );
    if ( response[0] ) {
        char    *p = strstr( response, "name=\"var_dummy\"" );
        char    *q;

        if ( p ) {
            p += 16;
            q = strstr( p, "value=\"" );
            if ( q ) {
                q += 7;
                p = strchr( q, '"' );
                if ( p ) {
                    strncpy( var_dummy, q, p - q );
                    var_dummy[p - q] = NUL;
                }
            }
        }

        p = strstr( response, "name=\"ch\"" );
        if ( p ) {
            p += 9;
            q = strstr( p, "value=\"" );
            if ( q ) {
                q += 7;
                p = strchr( q, '"' );
                if ( p ) {
                    strncpy( ch, q, p - q );
                    ch[p - q] = NUL;
                }
            }
        }

        if ( categoryName && *categoryName ) {
            /* JeS  JeSID ϊ */
            char    catID[64];

            getCategoryIDbyName( catID, categoryName, response,
                                 "<select name=\"cate_id\">",
                                 "</select>",
                                 "<option value=\"", "\">",
                                 CHARSET_EUCJP );
            if ( *catID )
                categoryID = atol( catID );
        }

        /* e */
        strcpy( url, "http://my.plaza.rakuten.co.jp/" );
        setTargetURL( url );

        t  = time( NULL );
        tm = localtime( &t );
        yyyy = tm->tm_year + 1900;
        mm   = tm->tm_mon + 1;
        dd   = tm->tm_mday;

        sprintf( request,
                 "theme_id=0&current_theme_id=0&ex_cate_id=0&"
                 "cate_id=%d&"  /* JeSID (e[}ID) */
                 "d_title=%s&"  /* 薼 (160oCgȓ)  */
                 "d_text=%s&"   /* { */
                 "d_img_service=&"
                 "d_img_filename=&"
                 "d_img_position=0&"
                 "d_feel=1&"    /* C (: 1) */
                 "d_himitsu=&"  /* JL */
                 "s_d_img_fileid=&"
                 "s_d_img_position=&"
                 "s_d_imgurl=&"
                 "s_d_img_title=&"
                 "s_d_img_w=&"
                 "s_d_img_h=&"
                 "t_img_service=&"
                 "char_dummy=%s&"
                 "var_dummy=%s&"
                 "d_date=%04d-%02d-%02d&"
                 "func=diary&act=write&"
                 "sub_act=insert&"
                 "ch=%s",
                 categoryID,
                 title, body, sjis2euc( "yV"),
                 var_dummy, yyyy, mm, dd, ch );

        setUpReceiveBuffer( response, sz );
     // ret = httpPostWithSession( xmlrpc_p->webServer, xmlrpc_p->webPage,
     //                            "application/x-www-form-urlencoded",
     //                            request, response, cookie,
     //                            NULL, NULL );
        http_postEx( url, "application/x-www-form-urlencoded",
                     request, response, cookie );
        if ( response[0] &&
             strstr( response, sjis2euc( "݂܂" ) ) )
            ret = 0;    /* e */
        else
            ret = -1;   /* es */
        /* : yVL13܂łełȂB4ڂ𓊍e悤 */
        /*       ƃG[ɂȂ                                        */
    }
    else
        ret = -1;

    free( response );
    free( request  );

    return ( ret == -1 ? 0 : 1 );
}


char    *
editForRakuten( char *text )
{
    char    *p = text;
    char    *tmp, *q, *r;

    if ( !p || !(*p) )
        return ( text );

    tmp = (char *)malloc( strlen( p ) + 1 );
    if ( tmp )
        q = tmp;
    else
        q = p;

    /* ̊֐̏e                  */
    /*   (1) class="xxx" 菜 [K{] */

    while ( *p ) {
        if ( !strncmp( p, "class=", 6 ) ) {
            /* (1) class="xxx" 菜 */
            r = strchr( p + 6, '"' );
            if ( r ) {
                r = strchr( r + 1, '"' );
                if ( r ) {
                    p = r + 1;
                    continue;
                }
            }

            r = strchr( p + 6, ' ' );
            if ( r ) {
                p = r;
                *q++ = *p++;// ' '
            }
            else if ( ( r = strchr( p + 6, '>') ) != NULL ) {
                p = r;
                *q++ = *p++;// '>'
            }
            else
                p += 6;
        }
        else
            *q++ = *p++;
    }
    *q = NUL;

    if ( tmp ) {
        strcpy( text, tmp );
        free( tmp );
    }

    return ( text );
}

int
postArticleOnRakuten( const char *username,         /* [U     */
                      const char *password,         /* pX[h   */
                      char       *title,            /* eL薼 */
                      char       *body,             /* eL{ */
                      const char *categoryName,     /* JeS   */
                      int        forceWritingForPet /* 㗝e */
                    )
{
    int     ret     = 0;
    char    *cookie = (char *)malloc( MAX_COOKIE_LEN );
    char    myBlogURL[MAX_URLLENGTH];

    if ( cookie ) {
        memset( cookie, 0x00, MAX_COOKIE_LEN );
        if ( loginRakuten( username, password, cookie, myBlogURL ) ) {
            char    *s, *t;
            s = utf2euc( title );
            strcpy( title, s );
            if ( !forceWritingForPet )
                strcat( title, " [via cocousagi]" );
            else {
                time_t      t = time( NULL );
                struct tm   *tm = localtime( &t );

                sprintf( title + strlen( title ),
                         " (%04d/%02d/%02d)",
                         tm->tm_year + 1900, tm->tm_mon + 1, tm->tm_mday);
            }
            t = sjis2euc( editForRakuten( body ) );
            strcpy( body,  t );
            ret = postRakuten( username, password, cookie,
                               categoryName, title, body );
        }

        free( cookie );
    }
    else
        fprintf( stderr, "login Ɏs܂B\n" );

    return ( ret );
}
