/*
 * Copyright 2009 Project CodeCluster
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KI ND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codecluster;

/**
 * 共通定数がされています。
 */
public interface C2Constants {
	/**
	 * 共通プロパティファイル名。
	 * {@value}。<br>
	 */
	public static final String DEFAULT_CONFIG_XML = "C2config.xml";
	/**
	 * 共通プロパティのキャッシュ秒数を指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_CACHE_SECONDS = "cache";
	/**
	 * リダイレクトルールのクラスを指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_REDIRECT_RULE_CLASS = "redirect-rule-class";
	/**
	 * シンプルなリダイレクトルールの設定項目。基本URLを指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_SIMPLE_REDIRECT_BASE =  "redirect-base";
	/**
	 * 本当のリモートアドレスを取得するリクエストヘッダーを指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_REMOTE_ADDRESS_HEADER = "remote-address-header";
	/**
	 * SSL通信かどうかを判断するリクエストヘッダーを指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_SECURE_HEADER = "secure-header";
	/**
	 * SSL通信かどうかを判断するリクエストヘッダーの値を指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_SECURE_TRUE_KEYWORD = "secure-true-keyword";
	/**
	 * C2Session の新規作成時に設定する有効期限の値を指定するプロパティ名。
	 * {@value}。<br>
	 */
	public static final String CONF_C2SESSION_TIMEOUT = "c2session-timeout";
}
