/*
 * Copyright 2009 Project CodeCluster
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KI ND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codecluster.http;

import javax.servlet.http.HttpServletRequest;

/**
 * リダイレクトURLを生成するルールを記述するためのインタフェースです。
 */
public interface RedirectRule {

	/**
	 * @param location
	 * @param request
	 * @return リダイレクト後の URL 
	 */
	public String redirect(String location, HttpServletRequest request);
}
