package org.codecluster.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.codecluster.lang.StringUtils;

public class Digester {

	/**
	 * 指定されたダイジェストアルゴリズム algorithm で input をハッシュ化したダイジェスト文字列を返却します。
	 * @param input 暗号化対象の入力文字列 ("MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"...)
	 * @param algorithm アルゴリズム名
	 * @return ダイジェスト文字列（16進数文字列）
	 * @see java.security.MessageDigest#getInstance
	 * @throws NoSuchAlgorithmException
	 */
	public static String getDigestString( String input, String algorithm ) throws NoSuchAlgorithmException {
		if( input     == null ) throw new IllegalArgumentException("Method argument 'input' is null.") ;
		if( algorithm == null ) throw new IllegalArgumentException("Method argument 'algorithm' is null.") ;

		MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
		messageDigest.reset();
		messageDigest.update(input.getBytes());
		byte[] hash = messageDigest.digest();

		return StringUtils.toHexString(hash);
	}
}
