import java.io.FileNotFoundException;
import java.io.PrintStream;

public final class CovMan {
	private static PrintStream _out;
	
	static {
		try {
			_out = new PrintStream("coverage_result.txt");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
			_out = System.out;
		}
	}
	
	private static void write(String key, String value) {
		_out.println(value + "," + key);
	}
	
	public static boolean branch(String key, boolean value) {
		write(key, value ? "1" : "2");
		return value;
	}
	
	public static void statement(String key) {
		write(key, "3");
	}
}
