#!/usr/local/bin/ruby
#
# $Id: $
#
require "codediff/codediff.rb"

module CodeDiff
  module RcsConf
    CvsCommand = "/usr/bin/cvs"

    def revision
      maxDate = Time.now - 3600*24*3650
      `#{CvsCommand} status`.split("\n").each do |line|
        if line.match(/Date\:\s+(\d+)\.(\d+)\.(\d+)\.(\d+)/) then
          date = Time.mktime($1, $2, $3, $4)
          if maxDate < date then
            maxDate = date
          end
        end
      end
      maxDate
    end

    def titleString(prev, curr)
      "Rev #{prev.strftime("%Y%m%d")} -> #{curr.strftime("%Y%m%d")}"
    end

    def cmdUpdate
      "#{CvsCommand} update -D#{Time.now.strftime("%Y%m%d")}"
    end

    def cmdFullDiff(prev)
      "#{CvsCommand} diff -D#{prev.strftime("%Y%m%d")} --unified=50 --ignore-all-space"
    end
    def cmdDiff(prev)
      "#{CvsCommand} diff -D#{prev.strftime("%Y%m%d")} --unified=10 --ignore-all-space"
    end
  end
end

if $0 == __FILE__ then
  RepoPath     = ARGV[0]
  RelPath      = ARGV[1]
  BaseURL      = ARGV[2]
  TimeStamp    = Time.now
  ListFileName = "#{TimeStamp.strftime("%Y%m%d_%H%M%S_%a")}_list.html"
  DiffFileName = "#{TimeStamp.strftime("%Y%m%d_%H%M%S_%a")}_diff.html"
  app = CodeDiff::CodeDiffApp.new(RepoPath, RelPath, BaseURL, ListFileName, DiffFileName)
  app.run
end
