#!/usr/local/bin/ruby
#
# $Id: $
#
# LICENSE: GPL
# EXAMPLE: % diff -u  | ./diff2rss20.rb > output.html
#          % svn diff | ./diff2rss20.rb > output.html
#          % cvs diff --unified=10 --ignore-all-space | ./diff2rss20.rb > output.html
#
require "kconv"
require "codediff/diffparser.rb"
require "codediff/utility.rb"
require "codediff/config.rb"

module CodeDiff
  class Diff2Rss20 < DiffParser
    include CodeDiff::XmlTool
    include CodeDiff::HtmlConf
    include CodeDiff::RssConf

    @ostream
    @diffurl
    @now
    @strBuffer

    def initialize(os, diffurl)
      @ostream = os
      @diffurl = diffurl
      @now = Time.now
      @strBuffer = ""
    end

    #
    # Override
    #

    def startParse
      @strBuffer << <<HEAD
<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<rss version=\"2.0\">
<channel>
HEAD
      printChannelHeader(@strBuffer)
    end

    def endParse
      @strBuffer << "</channel>\n</rss>"
      @strBuffer = Kconv.toutf8(@strBuffer)
      @ostream.print @strBuffer
    end

    def startDocument(source, target)
      @strBuffer << <<HEADER
<item>
<title>#{source}</title>
<link>#{@diffurl}##{source}</link>
<author>CodeDiff::Diff2Rss20</author>
<pubDate>#{@now}</pubDate>
<description>
<![CDATA[
HEADER
      @now = @now.succ
    end

    def endDocument
      @strBuffer << "]]>\n</description>\n</item>"
    end

    def startBlock(sourceBase, sourceLength, targetBase, targetLength)
      @strBuffer << <<BLOCK
<h3>From #{sourceBase} to #{sourceBase.to_i+sourceLength.to_i}</h3>
<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">
BLOCK
    end

    def endBlock
      @strBuffer << "</table>"
    end

    def sourceLine(line)
      line = sanitize(line)
      @strBuffer << "<tr><td bgcolor=\"#aaaaaa\"><tt>#{line}</tt></td></tr>"
    end

    def targetLine(line)
      line = sanitize(line)
      @strBuffer << "<tr><td bgcolor=\"#ffff00\"><tt>#{line}</tt></td></tr>"
    end

    def commonLine(line)
      line = sanitize(line)
      @strBuffer << "<tr><td bgcolor=\"#dddddd\"><tt>#{line}</tt></td></tr>"
    end

  end
end

if $0 == __FILE__ then
  app = CodeDiff::Diff2Rss20.new(STDOUT, ARGV[0])
  app.parse(STDIN)
end
