#
# $Id: $
#
# LICENSE: GPL
#
module CodeDiff
  class DiffParser

    @source
    @started
    @blockStarted

    def initialize
      @source = ""
      @started = false
      @blockStarted = false
    end

    def startParse
    end

    def endParse
    end

    def startDocument(source, target)
    end

    def endDocument
    end

    def startBlock(sourceBase, sourceLength, targetBase, targetLength)
    end

    def endBlock
    end

    def sourceLine(line)
    end

    def targetLine(line)
    end

    def commonLine(line)
    end

    def parse(istream)
      startParse
      istream.each do |line|
        if /^\-\-\-[\t\s]*([\w+\.\/\\\:]+)/.match(line) then
          @source = $1
        elsif /^\+\+\+[\t\s]*([\w+\.\/\\\:]+)/.match(line) then
          target = $1
          if @started then
            endDocument
          end
          startDocument(@source, target)
          @started = true
        elsif /^\-(.*)/.match(line) then
          sourceLine($1)
        elsif /^\+(.*)/.match(line) then
          targetLine($1)
        elsif /^\s(.*)/.match(line) then
          commonLine($1)
        elsif /^@@\s\-(\d+),(\d+)\s\+(\d+),(\d+)\s@@/.match(line) then
          if @blockStarted then
            endBlock
          end
          startBlock($1, $2, $3, $4)
          @blockStarted = true
        end
      end
      if @blockStarted then
        endBlock
      end
      if @started then
        endDocument
      end
      endParse
    end
  end
end
