#
# $Id: $
#
# LICENSE: GPL
#
module CodeDiff
  module XmlTool
    def convertIllegalCharacters(str)
      ret = str.chomp
      ret.gsub!( '&', '&amp;' )
      ret.gsub!('\'', '&apos;')
      ret.gsub!('"', '&quot;')
      ret.gsub!( '<', '&lt;'  )
      ret.gsub!( '>', '&gt;'  )
      ret.gsub!("\t", '&nbsp;&nbsp;&nbsp;&nbsp;')
      ret
    end

    def convertSpace(str)
      ret = str.gsub(' ', '&nbsp;')
      0 == ret.length ? '&nbsp;' : ret
    end

    def sanitize(str)
      ret = convertIllegalCharacters(str)
      ret = convertSpace(ret)
    end
  end
end
