package jp.sf.codememo;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

/**
 * 
 * @author bskuroneko
 */
public class CompositeElementResolver implements IElementResolver {

    private List resolvers = new ArrayList();
    
    public Object findSelectedElement(IWorkbenchPart part, ISelection selection) {
        Object result = null;
        for (Iterator it = resolvers.iterator(); result == null && it.hasNext();) {
            IElementResolver resolver = (IElementResolver) it.next();
            result = resolver.findSelectedElement(part, selection);
        }
        return result;
    }

    public String getLabel(Object element) {
        String result = null;
        for (Iterator it = resolvers.iterator(); result == null && it.hasNext();) {
            IElementResolver resolver = (IElementResolver) it.next();
            result = resolver.getLabel(element);
        }
        return result;
    }

    public File getRegistryPath(IPath basePath, Object element) {
        File result = null;
        for (Iterator it = resolvers.iterator(); result == null && it.hasNext();) {
            IElementResolver resolver = (IElementResolver) it.next();
            result = resolver.getRegistryPath(basePath, element);
        }
        return result;
    }

    public void addElementResolver(IElementResolver resolver) {
        resolvers.add(resolver);
    }

}
