var editor = ace.edit("content_body");
editor.fit = function() {
	$('#content_body').css('height',($(window).height() - 150) + 'px')
				      .css('width', ($(window).width() - 410) + 'px');

	var w = $(window);
	$('#content_body').css({
		height: (w.height() - 150) + 'px'
	});
	editor.resize(true);
};

var current = {
	contents: [],
	item_id: 0,
	item: null,
	content_id: 0,
	tree_dblclick: false
};

var MSG = {
	BTN_OK: 'OK',
	BTN_CANCEL: 'キャンセル',
	SETTING: '設定',
	NEW_GROUP: '新しいフォルダ',
	NEW_ITEM: '新しいスニペット',
	NEW_CONTENT: '新しいコンテンツ',
	DEFAULT_CONTENT_NAME: 'Untitled'
};

var $C = {
	groups_items: $('#groups_items'),
	tree_menu:    $('#tree-menu'),
	content_name: $('#content_name'),
	editor_lang:  $('#editor_lang'),
	dlg_newgroup: $('#dlg_newgroup'),
	dlg_newitem:  $('#dlg_newitem'),
	dlg_setting:  $('#dlg_setting'),
	lnk_config:   $('#lnk_config'),
	tab_menu:     $('#tab_menu'),
	tabs:         $('#tabs')
};

var createTabBtnHTML = function(id, lang, name) {
	return '<a href="#" class="tabbtn" data-id="'+id+'" data-options="iconCls: \'icon-lang-'+lang+'\'">'+name+'</a>';
};

//tree
$C.groups_items.etree({
	dnd: true,
	dndUrl: 'api/tree/sort',
	updateUrl: 'api/tree/update',
	onContextMenu: function(e, node){
		e.preventDefault();

		current.item_id = node.attributes.itemid;
		current.item = node;

		$C.groups_items.etree('select', node.target);
		$C.tree_menu.menu('show', {
			left: e.pageX,
			top: e.pageY
		});
	},
	onClick: function(node){
		setTimeout(function() {
			if(current.tree_dblclick === true) { return; }

			current.item_id = node.attributes.itemid;
			current.item = node;

			if(node.attributes.type === 'group') {
				//コンテンツ追加ボタン・メニューバーの無効化
				enableContentMenubar(false);
			}else{
				enableContentMenubar(true);
				loadContents(current.item_id);
			}
		},250); //ダブルクリック監視待ち時間
	},
	onBeforeDrop: function(target, source, point) {
		var target_item_id = $C.groups_items.tree('getNode', target).attributes.itemid;
		var is_group = target_item_id.slice(0,1) === 'g' ? true : false;
		var top_bottom = (point === 'top') || (point === 'bottom') ? true : false;

		var source_type = source.attributes.type;

		if(source_type === 'group' && top_bottom ) { //フォルダ同士の並べ替え
		}else if(source_type === 'item' && !is_group && top_bottom) { //同一フォルダの並べ替え
		}else if(source_type === 'item' && is_group && !top_bottom){ //フォルダ間の移動
		}else{
			return false;
		}

	}

});

var loadContents = function(item_id, content_id) {
	item_id = item_id.split(':').pop();
	$.getJSON('api/itemcontents/data/'+item_id+'.json', function(json){
		if(!json) { json = []; }
	
		var new_val = '';
		for(var i = 0; i < json.length; i++) {
			var content = json[i];
			new_val += createTabBtnHTML(content.id, content.lang, content.name);
		}
		document.getElementById('tabs').innerHTML = new_val;
	
		var tabbtn = $('.tabbtn');
		tabbtn.linkbutton().click(tabbtnOnClick);

		current.contents = json;
		if(current.contents.length > 0) {
			if(content_id === undefined) {
				tabbtn.first().click();
			}else{
				console.log(tabbtn);
				for(var i = 0; i < tabbtn.length; i++) {
					var tab = $(tabbtn[i]);
					if(content_id === tab.attr('data-id')) {
						tab.click();
					}
				}
			}
		}else{
			//コンテンツが無い場合は自動で一つ追加
			$('#btn_add_contents').click();
		}
	});
};

var tabbtnOnClick = function() {
	var target_id = $(this).attr('data-id');
	var contents = current.contents;
	for(var i = 0; i < contents.length; i++) {
		var content = contents[i];
		if(content.id === target_id) {
			current.content_id = target_id;
			editor.setValue(content.body);
			editor.clearSelection();
			editor.focus();
			$C.content_name.val(content.name);
			$C.editor_lang.combobox('select',content.lang);
		}
	}
	
	$('.tabbtn').removeClass('selected');
	$(this).addClass('selected');
};

$C.tree_menu.menu({  
    onClick:function(item){  
		switch(item.id) {
			case 'menu_new_group':
				$.post('api/groups/add',{
					name: MSG.NEW_GROUP
				},function() {
					$C.groups_items.etree('reload');
				});
				break;
			case 'menu_new_item':
				var tmp = current.item_id.split(':');
				var type = tmp[0];
				var group_id = tmp.pop();

				if(type === 'i') {
					//選択中のノードがアイテムの場合
					var parent = $C.groups_items.etree('getParent', current.item.target);
					tmp = parent.attributes.itemid.split(':');
					group_id = tmp.pop();
				}

				$.post('api/items/add',{
					group_id: group_id,
					name: MSG.NEW_ITEM
				},function() {
					$C.groups_items.etree('reload');
				});

				break;
			case 'menu_remove_item':
				$.post('api/items/remove',{
					id: current.item_id
				},function() {
					$C.groups_items.etree('reload');
					enableContentMenubar(false);
				});
				break;
		}
    }  
});

var doSearch = function(value) {
	$C.groups_items.etree({url: 'api/tree/index.json?q='+value});
};

$('#editor_lang').combobox({
	onSelect: function(record) {
		console.log(record);
		var mode = 'ace/mode/'+record.value;
		editor.getSession().setMode(mode);
	}
});


//設定ダイアログ
$C.dlg_setting.dialog({
	title: MSG.SETTING,
	href: 'setting/index',
	width: 400,
	height: 300,
	closed: true
});
$C.lnk_config.click(function() {
	$C.dlg_setting.dialog('open');
});


//コンテンツの追加ボタン
$('#btn_add_contents').click(function() {
	$('#new_content_name').val('');
	var item_id = current.item_id.split(':').pop();
	
	$.post('api/itemcontents/add',{
		item_id: item_id,
		name: MSG.DEFAULT_CONTENT_NAME
	},function(){
		loadContents(current.item_id);
	});
	
});

//保存ボタン
$('#btn_content_save').click(function() {
	var id = current.content_id;
	var name = $('#content_name').val();
	var body = editor.getValue();
	var lang = $C.editor_lang.combobox('getValue');

	$.post('api/itemcontents/update', {
		id: id,
		name: name,
		body: body,
		lang: lang
	},function() {
		loadContents(current.item_id, current.content_id);
	});

});

//削除ボタン
$('#btn_content_remove').click(function(){
	$.messager.confirm('コンテンツの削除','このコンテンツは完全に削除されます',function(r){  
    	if (r){  
			$.post('api/itemcontents/remove', {
				id: current.content_id
			},function(){
				loadContents(current.item_id);
			});
    	} 
	});  
});

var enableContentMenubar = function(enabled, isFirst) {
	var bool_text = enabled ? 'enable' : 'disable';
	var visibility = enabled ? '' : 'hidden';
	$C.tab_menu.css('visibility', visibility);
	$C.tabs.css('visibility', visibility);
	$('#content_menu *').css('visibility', visibility);
	$C.content_name.val('');

	if(!isFirst) {
		editor.setValue('');
	}
};

function fitLayout() {
	editor.fit();
}

$C.content_name.focus(function() {
	$(this).select();
});

//init
enableContentMenubar(false, true);
fitLayout();
$(window).resize(function () {
	fitLayout();
});

//layout
setTimeout(function () {
$('body').layout('panel', 'west').panel({
	onResize: function(width, height) {
		$('#search_box').searchbox('resize', width - 10);
	}
});
},2000);