<?php

class Controller_Setting extends Controller_Template
{

	public function action_index()
	{
		$langs = Model_Lang::find_all();

		$data = array(
			'langs' => $langs,
		);
		return new Response(View::forge('setting/index', $data));

	}

	public function action_update_lang()
	{
		$enable_langs = implode(',', Input::post('langs')) . ',';

		$all_langs = Model_Lang::find_all();
		foreach($all_langs as $lang) {
			$lang->enabled = (strpos($enable_langs, $lang->name.',') !== false) ? 1 : 0;
			$lang->save();
		}

		Response::redirect('/');

	}

}
