<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title><?php echo $title; ?></title>
	<link rel="shortcut icon" href="assets/favicon.ico" type="image/vnd.microsoft.icon">
	<?php echo Asset::add_path('assets/jquery-easyui/', 'css'); ?>
	<?php echo Asset::add_path('assets/jquery-easyui/', 'js'); ?>
	<?php echo Asset::add_path('assets/jquery-easyui/extensions/', 'js'); ?>
	<?php echo Asset::add_path('assets/jquery-easyui/', 'img'); ?>
	<?php echo Asset::add_path('assets/ace/', 'js'); ?>
	<?php echo Asset::add_path('js/', 'js'); ?>

	<?php echo Asset::css('themes/black/easyui.css'); ?>
	<?php echo Asset::css('themes/icon.css'); ?>
	<?php echo Asset::css('app.css'); ?>

</head>
<body class="easyui-layout">

	<div id="header" data-options="region:'north'">
		<div id="title_bar">
			<a href="./">CodePiece</a>
		</div>

		<div id="menu_bar">
			<a id="lnk_config" href="#" class="easyui-linkbutton" data-options="plain:true">Config</a>
		</div>

	</div>

	<div id="categories" data-options="region:'west',split:true">
		<input id="search_box" class="easyui-searchbox" data-options="prompt:'Search',searcher:doSearch" style="display: block; width: 390px;">

		<!-- groups and items -->
		<ul id="groups_items" class="easyui-tree" data-options="url: 'api/tree/index.json'"></ul> 
	</div>

	<div id="content" data-options="region:'center',split:true">
		<div id="tab_menu">
			<a id="btn_add_contents" href="#" class="easyui-linkbutton" data-options="plain:true, iconCls:'icon-add'">追加</a>
		</div>
		<div id="tabs">
		</div>
		<div id="content_menu">
			<span>名前：</span>
			<input type="text" id="content_name">
			<span class="spacer"></span>
			<span>言語:</span>
			<select id="editor_lang" class="easyui-combobox">
				<?php echo Model_Lang::getHtmlOptions(); ?>
			</select>
			<span class="spacer"></span>
			<a id="btn_content_save" href="#" class="easyui-linkbutton" data-options="plain:true, iconCls:'icon-save'">保存</a>
			<a id="btn_content_remove" href="#" class="easyui-linkbutton" data-options="plain:true, iconCls:'icon-remove'">削除</a>
		</div>

		<div id="content_body">
		ようこそ

        CodePieceはシンプルなスニペット管理ツールです。

        基本的なスニペット作成の流れは
             スニペット用フォルダの作成
             スニペットの作成
             コーディング
        となります。
		
		まずは、フォルダを作成しましょう。
			左のツリーを右クリックして、「新しいフォルダ」をクリックします。
			追加されたフォルダをダブルクリックすることで名前を変更できます。

		次にフォルダ内にスニペットを登録しましょう。
			対象のフォルダを右クリックして、「新しいスニペット」をクリックします。
			追加されたスニペットをダブルクリックすることで名前を変更できます。
		
		スニペットの登録が終わったら、早速コーディングをスタートしましょう。
        エディタ上部のツールバーで名前を付けたり言語の選択を行えます。
        選択できる言語は左上の「Config」から追加することも出来ます。

        コーディングが終わったらツールバーの「保存」ボタンをクリックし、保存します。

        htmlとcssなど複数の言語の場合はツールバーの「追加」ボタンからタブを追加できます。
		</div>

	</div>
		
		
	<!-- context menu for tree-view -->
    <div id="tree-menu" class="easyui-menu" style="width:120px;">  
        <div id="menu_new_group">新しいフォルダ</div>
        <div id="menu_new_item">新しいスニペット</div>
        <div class="menu-sep"></div>  
		<div id="menu_remove_item">この項目を削除</div>
    </div>  

	<!-- setting window -->
	<div id="dlg_setting">
	</div>

<?php //call javascripts
	echo Asset::js('jquery.min.js');
	echo Asset::js('jquery.easyui.min.js');
	echo Asset::js('jquery.etree.js');
	echo Asset::js('ace.js');
	echo Asset::js('app_main.js');
?>
</body>
</html>
