typedef	struct __sFILE {
	unsigned char *_p;	/* current position in (some) buffer */
	int	_r;		/* read space left for getc() */
	int	_w;		/* write space left for putc() */
	short	_flags;		/* flags, below; this FILE is free if 0 */
	short	_file;		/* fileno, if Unix descriptor, else -1 */
    /* .....  */
} FILE;

extern FILE *__stdinp;
extern FILE *__stdoutp;
extern FILE *__stderrp;

#define	stdin	__stdinp
#define	stdout	__stdoutp
#define	stderr	__stderrp

#define NULL 0

 int remove(const char*); 
 int rename(const char*, const char*); 
 FILE* tmpfile(void); 
 char* tmpnam(char*); 
 int fclose(FILE*); 
 int fflush(FILE*); 
 FILE* fopen(const char*, const char*); 
 FILE* freopen(const char*, const char*, FILE*); 
 void setbuf(FILE*, char*);
 int setvbuf(FILE*, char*, int, size_t); 
 int fprintf(FILE*, const char*, ...); 
 int fscanf(FILE*, const char*, ...); 
 int printf(const char*, ...); 
 int scanf(const char*, ...); 
 int snprintf(char *, size_t, const char*, ...);
 int sprintf(char *, const char*, ...); 
 int sscanf(const char*, const char*, ...); 
 int vfprintf(FILE*, const char*, va_list); 
 int vfscanf(FILE*, const char*, va_list); 
 int vprintf(const char*, va_list); 
 int vscanf(const char*, va_list); 
 int vsnprintf(char*, size_t, const char*, va_list); 
 int vsprintf(char*, const char*, va_list); 
 int vsscanf(const char*, const char*, va_list); 
 int fgetc(FILE *); 
 char *fgets(char*, int, FILE*); 
 int fputc(int, FILE*); 
 int fputs(const char*, FILE*); 
 int getc(FILE*); 
 int getchar(void); 
 char *gets(char*); 
 int putc(int, FILE*); 
 int putchar(int); 
 int puts(const char*); 
 int ungetc(int, FILE*);
 size_t fread(void*, size_t, size_t, FILE*); 
 size_t fwrite(const void*, size_t, size_t, FILE*); 
/* int fgetpos(FILE*, fpos_t*);*/
 int fseek(FILE*, long int, int); 
/* int fsetpos(FILE*, const fpos_t*);*/
 long int ftell(FILE*); 
 void rewind(FILE*); 
 void clearerr(FILE*); 
 int feof(FILE*); 
 int ferror(FILE*); 
 void perror(const char*);

