package coins.backend.gen;

import coins.backend.Storage;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;

public class MachineParams_arm extends coins.backend.MachineParams {

  public void addRequired(SymTab symtbl) {
    symtbl.addSymbol("__modsi3", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol("__umodsi3", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol("__divsi3", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol("__udivsi3", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
    symtbl.addSymbol("memcpy", Storage.STATIC, 0, 4, "text", "XREF", ImList.Empty);
  }

  public int nRegisters() { return 42; }
  public int nRegsets() { return 52; }

  public int typeAddress() { return 514; }
  public int typeBool() { return 514; }
  public String[] getSymName() {
    return new String[]{
      "%r0",
      "%r1",
      "%r2",
      "%r3",
      "%ip",
      "%lr",
      "%r4",
      "%r5",
      "%r6",
      "%r7",
      "%r8",
      "%r9",
      "%r10",
      "%fp",
      "%vfp",
      "%sp",
      "%pc",
      "%f0",
      "%f1",
      "%f2",
      "%f3",
      "%f4",
      "%f5",
      "%f6",
      "%f7",
      "%r0/I16/0",
      "%r1/I16/0",
      "%r2/I16/0",
      "%r3/I16/0",
      "%r4/I16/0",
      "%r5/I16/0",
      "%r6/I16/0",
      "%r7/I16/0",
      "%r8/I16/0",
      "%r9/I16/0",
      "%r10/I16/0",
      "%r0/I8/0",
      "%r1/I8/0",
      "%r2/I8/0",
      "%r3/I8/0",
      "%r4/I8/0",
      "%r5/I8/0",
      "%r6/I8/0",
      "%r7/I8/0",
      "%r8/I8/0",
      "%r9/I8/0",
      "%r10/I8/0",
      "%f0/F32/0",
      "%f1/F32/0",
    };
  };
  public int[] getSymType() {
    return new int[] {
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      516,
      516,
    };
  };
  public int[] getSymRegNumber() {
    return new int[] {
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
      13,
      0,
      0,
      0,
      0,
      36,
      37,
      40,
      41,
      0,
      0,
      0,
      0,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      22,
      23,
      24,
      25,
      26,
      27,
      28,
      29,
      30,
      31,
      32,
      33,
      34,
      35,
      38,
      39,
    };
  };

  public short[][] getOverlapReg() {
    return new short[][] { {},
  /* 1: */ {14,25,},
  /* 2: */ {15,26,},
  /* 3: */ {16,27,},
  /* 4: */ {17,28,},
  /* 5: */ {},
  /* 6: */ {},
  /* 7: */ {18,29,},
  /* 8: */ {19,30,},
  /* 9: */ {20,31,},
  /* 10: */ {21,32,},
  /* 11: */ {22,33,},
  /* 12: */ {23,34,},
  /* 13: */ {24,35,},
  /* 14: */ {1,25,},
  /* 15: */ {2,26,},
  /* 16: */ {3,27,},
  /* 17: */ {4,28,},
  /* 18: */ {7,29,},
  /* 19: */ {8,30,},
  /* 20: */ {9,31,},
  /* 21: */ {10,32,},
  /* 22: */ {11,33,},
  /* 23: */ {12,34,},
  /* 24: */ {13,35,},
  /* 25: */ {1,14,},
  /* 26: */ {2,15,},
  /* 27: */ {3,16,},
  /* 28: */ {4,17,},
  /* 29: */ {7,18,},
  /* 30: */ {8,19,},
  /* 31: */ {9,20,},
  /* 32: */ {10,21,},
  /* 33: */ {11,22,},
  /* 34: */ {12,23,},
  /* 35: */ {13,24,},
  /* 36: */ {38,},
  /* 37: */ {39,},
  /* 38: */ {36,},
  /* 39: */ {37,},
  /* 40: */ {},
  /* 41: */ {},
    };
  };

  public short[][] getSuperReg() {
    return new short[][] { {},
  /* 1: */ {},
  /* 2: */ {},
  /* 3: */ {},
  /* 4: */ {},
  /* 5: */ {},
  /* 6: */ {},
  /* 7: */ {},
  /* 8: */ {},
  /* 9: */ {},
  /* 10: */ {},
  /* 11: */ {},
  /* 12: */ {},
  /* 13: */ {},
  /* 14: */ {1,},
  /* 15: */ {2,},
  /* 16: */ {3,},
  /* 17: */ {4,},
  /* 18: */ {7,},
  /* 19: */ {8,},
  /* 20: */ {9,},
  /* 21: */ {10,},
  /* 22: */ {11,},
  /* 23: */ {12,},
  /* 24: */ {13,},
  /* 25: */ {1,14,},
  /* 26: */ {2,15,},
  /* 27: */ {3,16,},
  /* 28: */ {4,17,},
  /* 29: */ {7,18,},
  /* 30: */ {8,19,},
  /* 31: */ {9,20,},
  /* 32: */ {10,21,},
  /* 33: */ {11,22,},
  /* 34: */ {12,23,},
  /* 35: */ {13,24,},
  /* 36: */ {},
  /* 37: */ {},
  /* 38: */ {36,},
  /* 39: */ {37,},
  /* 40: */ {},
  /* 41: */ {},
    };
  };

  public short[][] getSubReg() {
    return new short[][] { {},
  /* 1: */ {14,25,},
  /* 2: */ {15,26,},
  /* 3: */ {16,27,},
  /* 4: */ {17,28,},
  /* 5: */ {},
  /* 6: */ {},
  /* 7: */ {18,29,},
  /* 8: */ {19,30,},
  /* 9: */ {20,31,},
  /* 10: */ {21,32,},
  /* 11: */ {22,33,},
  /* 12: */ {23,34,},
  /* 13: */ {24,35,},
  /* 14: */ {25,},
  /* 15: */ {26,},
  /* 16: */ {27,},
  /* 17: */ {28,},
  /* 18: */ {29,},
  /* 19: */ {30,},
  /* 20: */ {31,},
  /* 21: */ {32,},
  /* 22: */ {33,},
  /* 23: */ {34,},
  /* 24: */ {35,},
  /* 25: */ {},
  /* 26: */ {},
  /* 27: */ {},
  /* 28: */ {},
  /* 29: */ {},
  /* 30: */ {},
  /* 31: */ {},
  /* 32: */ {},
  /* 33: */ {},
  /* 34: */ {},
  /* 35: */ {},
  /* 36: */ {38,},
  /* 37: */ {39,},
  /* 38: */ {},
  /* 39: */ {},
  /* 40: */ {},
  /* 41: */ {},
    };
  };

  public String[] getRegsetName() {
    return new String[] {
      "*reg-r0-I32*",
      "*reg-r1-I32*",
      "*reg-ip-I32*",
      "*reg-I32*",
      "*reg-I16*",
      "*reg-I8*",
      "*reg-F64*",
      "*reg-F32*",
      "*reg-nlr-I32*",
      "*reg-call-clobbers*",
      "*reg-callee-saves*",
    };
  };
  public int[] getRegsetNumber() {
    return new int[] {
      1,
      2,
      5,
      42,
      43,
      44,
      45,
      46,
      47,
      48,
      49,
    };
  };
  public short[][] getRegsetMap() {
    return new short[][] {
      {1,2,3,4,5,6,7,8,9,10,11,12,13,},
      {14,15,16,17,18,19,20,21,22,23,24,},
      {25,26,27,28,29,30,31,32,33,34,35,},
      {36,37,},
      {38,39,},
      {1,2,3,4,5,7,8,9,10,11,12,13,},
      {1,2,3,4,5,6,36,37,40,41,},
      {7,8,9,10,11,12,13,},
      {1,2,3,4,5,6,},
      {1,2,3,4,5,},
    };
  };

  public short[] getRegsetNAvail() {
    return new short[] {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 13, 11, 11, 2, 2, 12, 10, 7, 
      6, 5,     };
  };

  public int[] getCompAndTbl() {
    return new int[] {
      -862,1,2,3,4,5,6,7,8,9,10,11,12,13,
      -917,14,15,16,17,18,19,20,21,22,23,24,
      -971,25,26,27,28,29,30,31,32,33,34,35,
      -1026,36,37,
      -1073,38,39,
      -1082,1,2,3,4,5,
      -1088,7,8,9,10,11,12,13,
      -1123,47,
      -1129,1,2,3,4,5,6,
      -1164,36,37,
      -1168,40,41,50,
      -1173,45,
      -1175,51,
      -1183,7,8,9,10,11,12,13,
      -1218,49,
      -1223,49,
      -1226,1,2,3,4,5,6,
      -1267,50,
      -1272,51,50,
      -1276,1,2,3,4,5,
      -1317,51,
      -1322,51,51,
      -1325,51,    };
  };

  public int[] getCompWeightTbl() {
    return new int[] {
    53,65,
    66,65,
    77,65,
    94,193,
    99,129,
    102,129,
    106,65,
    119,65,
    130,65,
    146,193,
    151,129,
    154,129,
    159,65,
    172,65,
    183,65,
    198,193,
    203,129,
    206,129,
    212,65,
    225,65,
    236,65,
    250,193,
    255,129,
    258,129,
    265,65,
    302,65,
    307,129,
    310,129,
    318,65,
    354,65,
    360,65,
    362,65,
    371,65,
    382,65,
    393,65,
    406,193,
    411,65,
    413,65,
    424,65,
    435,65,
    446,65,
    458,193,
    463,65,
    465,65,
    477,65,
    488,65,
    499,65,
    510,193,
    515,65,
    517,65,
    530,65,
    541,65,
    552,65,
    562,193,
    567,65,
    569,65,
    583,65,
    594,65,
    605,65,
    614,193,
    619,65,
    621,65,
    636,65,
    647,65,
    658,65,
    666,193,
    671,65,
    673,65,
    689,65,
    700,65,
    711,65,
    718,193,
    723,65,
    725,65,
    729,65,
    742,65,
    753,65,
    770,193,
    775,129,
    778,129,
    782,65,
    795,65,
    806,65,
    822,193,
    827,129,
    830,129,
    835,65,
    848,65,
    859,65,
    874,193,
    879,129,
    882,129,
    888,65,
    901,65,
    912,65,
    926,193,
    931,129,
    934,129,
    943,65,
    954,65,
    965,65,
    978,193,
    983,65,
    985,65,
    996,65,
    1007,65,
    1018,65,
    1030,193,
    1035,65,
    1037,65,
    1049,65,
    1060,65,
    1071,65,
    1082,193,
    1087,65,
    1089,65,
    1102,65,
    1113,65,
    1124,65,
    1134,193,
    1139,65,
    1141,65,
    1155,65,
    1166,65,
    1177,65,
    1186,193,
    1191,65,
    1193,65,
    1208,65,
    1219,65,
    1230,65,
    1238,193,
    1243,65,
    1245,65,
    1261,65,
    1272,65,
    1283,65,
    1290,193,
    1295,65,
    1297,65,
    1301,65,
    1314,65,
    1325,65,
    1342,193,
    1347,129,
    1350,129,
    1354,65,
    1367,65,
    1378,65,
    1394,193,
    1399,129,
    1402,129,
    1407,65,
    1420,65,
    1431,65,
    1446,193,
    1451,129,
    1454,129,
    1460,65,
    1473,65,
    1484,65,
    1498,193,
    1503,129,
    1506,129,
    1515,65,
    1526,65,
    1537,65,
    1550,193,
    1555,65,
    1557,65,
    1568,65,
    1579,65,
    1590,65,
    1602,193,
    1607,65,
    1609,65,
    1621,65,
    1632,65,
    1643,65,
    1654,193,
    1659,65,
    1661,65,
    1674,65,
    1685,65,
    1696,65,
    1706,193,
    1711,65,
    1713,65,
    1727,65,
    1738,65,
    1749,65,
    1758,193,
    1763,65,
    1765,65,
    1780,65,
    1791,65,
    1802,65,
    1810,193,
    1815,65,
    1817,65,
    1833,65,
    1844,65,
    1855,65,
    1862,193,
    1867,65,
    1869,65,
    1908,65,
    1910,65,
    1917,129,
    1920,65,
    1961,65,
    1963,65,
    1969,129,
    1972,65,
    2012,65,
    2014,65,
    2021,129,
    2024,65,
    2065,65,
    2067,65,
    2073,129,
    2076,65,
    2120,65,
    2128,65,
    2173,65,
    2180,65,
    2185,2241,
    2226,193,
    2231,321,
    2237,257,
    2243,1857,
    2278,193,
    2283,321,
    2289,257,
    2295,1857,
    2330,193,
    2335,321,
    2376,257,
    2385,129,
    2388,65,
    2428,257,
    2437,129,
    2440,65,
    2445,321,
    2451,1857,
    2486,193,
    2491,321,
    2497,385,
    2510,257,
    2521,257,
    2532,833,
    2546,129,
    2555,449,
    2566,449,
    2577,449,
    2590,193,
    2595,65,
    2597,65,
    2601,385,
    2614,257,
    2625,257,
    2642,193,
    2647,129,
    2650,129,
    2653,321,
    2666,257,
    2677,257,
    2694,193,
    2699,129,
    2702,129,
    };
  };

  public int[] getRegsetTypeTbl() {
    return new int[] {
    -1,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    1028,
    1028,
    516,
    516,
    1028,
    1028,
    514,
    258,
    130,
    1028,
    516,
    514,
    514,
    514,
    514,
    514,
    };
  }
}
