package coins.backend.gen;

import coins.backend.Storage;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;

public class MachineParams_x86_64 extends coins.backend.MachineParams {

  public int nRegisters() { return 90; }
  public int nRegsets() { return 105; }

  public int typeAddress() { return 1026; }
  public int typeBool() { return 514; }
  public String[] getSymName() {
    return new String[]{
      "%rax",
      "%rcx",
      "%rdx",
      "%rsi",
      "%rdi",
      "%r8",
      "%r9",
      "%rbx",
      "%r10",
      "%r11",
      "%r12",
      "%r13",
      "%r14",
      "%r15",
      "%eax",
      "%ecx",
      "%edx",
      "%esi",
      "%edi",
      "%r8d",
      "%r9d",
      "%ebx",
      "%r10d",
      "%r11d",
      "%r12d",
      "%r13d",
      "%r14d",
      "%r15d",
      "%ax",
      "%cx",
      "%dx",
      "%si",
      "%di",
      "%r8w",
      "%r9w",
      "%bx",
      "%r10w",
      "%r11w",
      "%r12w",
      "%r13w",
      "%r14w",
      "%r15w",
      "%al",
      "%cl",
      "%dl",
      "%sil",
      "%dil",
      "%r8b",
      "%r9b",
      "%bl",
      "%r10b",
      "%r11b",
      "%r12b",
      "%r13b",
      "%r14b",
      "%r15b",
      "%xmm0",
      "%xmm1",
      "%xmm2",
      "%xmm3",
      "%xmm4",
      "%xmm5",
      "%xmm6",
      "%xmm7",
      "%xmm8",
      "%xmm9",
      "%xmm10",
      "%xmm11",
      "%xmm12",
      "%xmm13",
      "%xmm14",
      "%xmm15",
      "%xmm0s",
      "%xmm1s",
      "%xmm2s",
      "%xmm3s",
      "%xmm4s",
      "%xmm5s",
      "%xmm6s",
      "%xmm7s",
      "%xmm8s",
      "%xmm9s",
      "%xmm10s",
      "%xmm11s",
      "%xmm12s",
      "%xmm13s",
      "%xmm14s",
      "%xmm15s",
      "%rbp",
      "%rsp",
    };
  };
  public int[] getSymType() {
    return new int[] {
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      1026,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      514,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      258,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      1026,
      1026,
    };
  };
  public int[] getSymRegNumber() {
    return new int[] {
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      10,
      8,
      9,
      11,
      12,
      13,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      24,
      22,
      23,
      25,
      26,
      27,
      28,
      29,
      30,
      31,
      32,
      33,
      34,
      35,
      38,
      36,
      37,
      39,
      40,
      41,
      42,
      43,
      44,
      45,
      46,
      47,
      48,
      49,
      52,
      50,
      51,
      53,
      54,
      55,
      56,
      57,
      58,
      59,
      60,
      61,
      62,
      63,
      64,
      65,
      66,
      67,
      68,
      69,
      70,
      71,
      72,
      73,
      74,
      75,
      76,
      77,
      78,
      79,
      80,
      81,
      82,
      83,
      84,
      85,
      86,
      87,
      88,
      89,
      0,
    };
  };

  public short[][] getOverlapReg() {
    return new short[][] { {},
  /* 1: */ {15,29,43,},
  /* 2: */ {16,30,44,},
  /* 3: */ {17,31,45,},
  /* 4: */ {18,32,46,},
  /* 5: */ {19,33,47,},
  /* 6: */ {20,34,48,},
  /* 7: */ {21,35,49,},
  /* 8: */ {22,36,50,},
  /* 9: */ {23,37,51,},
  /* 10: */ {24,38,52,},
  /* 11: */ {25,39,53,},
  /* 12: */ {26,40,54,},
  /* 13: */ {27,41,55,},
  /* 14: */ {28,42,56,},
  /* 15: */ {1,29,43,},
  /* 16: */ {2,30,44,},
  /* 17: */ {3,31,45,},
  /* 18: */ {4,32,46,},
  /* 19: */ {5,33,47,},
  /* 20: */ {6,34,48,},
  /* 21: */ {7,35,49,},
  /* 22: */ {8,36,50,},
  /* 23: */ {9,37,51,},
  /* 24: */ {10,38,52,},
  /* 25: */ {11,39,53,},
  /* 26: */ {12,40,54,},
  /* 27: */ {13,41,55,},
  /* 28: */ {14,42,56,},
  /* 29: */ {1,15,43,},
  /* 30: */ {2,16,44,},
  /* 31: */ {3,17,45,},
  /* 32: */ {4,18,46,},
  /* 33: */ {5,19,47,},
  /* 34: */ {6,20,48,},
  /* 35: */ {7,21,49,},
  /* 36: */ {8,22,50,},
  /* 37: */ {9,23,51,},
  /* 38: */ {10,24,52,},
  /* 39: */ {11,25,53,},
  /* 40: */ {12,26,54,},
  /* 41: */ {13,27,55,},
  /* 42: */ {14,28,56,},
  /* 43: */ {1,15,29,},
  /* 44: */ {2,16,30,},
  /* 45: */ {3,17,31,},
  /* 46: */ {4,18,32,},
  /* 47: */ {5,19,33,},
  /* 48: */ {6,20,34,},
  /* 49: */ {7,21,35,},
  /* 50: */ {8,22,36,},
  /* 51: */ {9,23,37,},
  /* 52: */ {10,24,38,},
  /* 53: */ {11,25,39,},
  /* 54: */ {12,26,40,},
  /* 55: */ {13,27,41,},
  /* 56: */ {14,28,42,},
  /* 57: */ {73,},
  /* 58: */ {74,},
  /* 59: */ {75,},
  /* 60: */ {76,},
  /* 61: */ {77,},
  /* 62: */ {78,},
  /* 63: */ {79,},
  /* 64: */ {80,},
  /* 65: */ {81,},
  /* 66: */ {82,},
  /* 67: */ {83,},
  /* 68: */ {84,},
  /* 69: */ {85,},
  /* 70: */ {86,},
  /* 71: */ {87,},
  /* 72: */ {88,},
  /* 73: */ {57,},
  /* 74: */ {58,},
  /* 75: */ {59,},
  /* 76: */ {60,},
  /* 77: */ {61,},
  /* 78: */ {62,},
  /* 79: */ {63,},
  /* 80: */ {64,},
  /* 81: */ {65,},
  /* 82: */ {66,},
  /* 83: */ {67,},
  /* 84: */ {68,},
  /* 85: */ {69,},
  /* 86: */ {70,},
  /* 87: */ {71,},
  /* 88: */ {72,},
  /* 89: */ {},
    };
  };

  public short[][] getSuperReg() {
    return new short[][] { {},
  /* 1: */ {},
  /* 2: */ {},
  /* 3: */ {},
  /* 4: */ {},
  /* 5: */ {},
  /* 6: */ {},
  /* 7: */ {},
  /* 8: */ {},
  /* 9: */ {},
  /* 10: */ {},
  /* 11: */ {},
  /* 12: */ {},
  /* 13: */ {},
  /* 14: */ {},
  /* 15: */ {1,},
  /* 16: */ {2,},
  /* 17: */ {3,},
  /* 18: */ {4,},
  /* 19: */ {5,},
  /* 20: */ {6,},
  /* 21: */ {7,},
  /* 22: */ {8,},
  /* 23: */ {9,},
  /* 24: */ {10,},
  /* 25: */ {11,},
  /* 26: */ {12,},
  /* 27: */ {13,},
  /* 28: */ {14,},
  /* 29: */ {1,15,},
  /* 30: */ {2,16,},
  /* 31: */ {3,17,},
  /* 32: */ {4,18,},
  /* 33: */ {5,19,},
  /* 34: */ {6,20,},
  /* 35: */ {7,21,},
  /* 36: */ {8,22,},
  /* 37: */ {9,23,},
  /* 38: */ {10,24,},
  /* 39: */ {11,25,},
  /* 40: */ {12,26,},
  /* 41: */ {13,27,},
  /* 42: */ {14,28,},
  /* 43: */ {1,15,29,},
  /* 44: */ {2,16,30,},
  /* 45: */ {3,17,31,},
  /* 46: */ {4,18,32,},
  /* 47: */ {5,19,33,},
  /* 48: */ {6,20,34,},
  /* 49: */ {7,21,35,},
  /* 50: */ {8,22,36,},
  /* 51: */ {9,23,37,},
  /* 52: */ {10,24,38,},
  /* 53: */ {11,25,39,},
  /* 54: */ {12,26,40,},
  /* 55: */ {13,27,41,},
  /* 56: */ {14,28,42,},
  /* 57: */ {},
  /* 58: */ {},
  /* 59: */ {},
  /* 60: */ {},
  /* 61: */ {},
  /* 62: */ {},
  /* 63: */ {},
  /* 64: */ {},
  /* 65: */ {},
  /* 66: */ {},
  /* 67: */ {},
  /* 68: */ {},
  /* 69: */ {},
  /* 70: */ {},
  /* 71: */ {},
  /* 72: */ {},
  /* 73: */ {57,},
  /* 74: */ {58,},
  /* 75: */ {59,},
  /* 76: */ {60,},
  /* 77: */ {61,},
  /* 78: */ {62,},
  /* 79: */ {63,},
  /* 80: */ {64,},
  /* 81: */ {65,},
  /* 82: */ {66,},
  /* 83: */ {67,},
  /* 84: */ {68,},
  /* 85: */ {69,},
  /* 86: */ {70,},
  /* 87: */ {71,},
  /* 88: */ {72,},
  /* 89: */ {},
    };
  };

  public short[][] getSubReg() {
    return new short[][] { {},
  /* 1: */ {15,29,43,},
  /* 2: */ {16,30,44,},
  /* 3: */ {17,31,45,},
  /* 4: */ {18,32,46,},
  /* 5: */ {19,33,47,},
  /* 6: */ {20,34,48,},
  /* 7: */ {21,35,49,},
  /* 8: */ {22,36,50,},
  /* 9: */ {23,37,51,},
  /* 10: */ {24,38,52,},
  /* 11: */ {25,39,53,},
  /* 12: */ {26,40,54,},
  /* 13: */ {27,41,55,},
  /* 14: */ {28,42,56,},
  /* 15: */ {29,43,},
  /* 16: */ {30,44,},
  /* 17: */ {31,45,},
  /* 18: */ {32,46,},
  /* 19: */ {33,47,},
  /* 20: */ {34,48,},
  /* 21: */ {35,49,},
  /* 22: */ {36,50,},
  /* 23: */ {37,51,},
  /* 24: */ {38,52,},
  /* 25: */ {39,53,},
  /* 26: */ {40,54,},
  /* 27: */ {41,55,},
  /* 28: */ {42,56,},
  /* 29: */ {43,},
  /* 30: */ {44,},
  /* 31: */ {45,},
  /* 32: */ {46,},
  /* 33: */ {47,},
  /* 34: */ {48,},
  /* 35: */ {49,},
  /* 36: */ {50,},
  /* 37: */ {51,},
  /* 38: */ {52,},
  /* 39: */ {53,},
  /* 40: */ {54,},
  /* 41: */ {55,},
  /* 42: */ {56,},
  /* 43: */ {},
  /* 44: */ {},
  /* 45: */ {},
  /* 46: */ {},
  /* 47: */ {},
  /* 48: */ {},
  /* 49: */ {},
  /* 50: */ {},
  /* 51: */ {},
  /* 52: */ {},
  /* 53: */ {},
  /* 54: */ {},
  /* 55: */ {},
  /* 56: */ {},
  /* 57: */ {73,},
  /* 58: */ {74,},
  /* 59: */ {75,},
  /* 60: */ {76,},
  /* 61: */ {77,},
  /* 62: */ {78,},
  /* 63: */ {79,},
  /* 64: */ {80,},
  /* 65: */ {81,},
  /* 66: */ {82,},
  /* 67: */ {83,},
  /* 68: */ {84,},
  /* 69: */ {85,},
  /* 70: */ {86,},
  /* 71: */ {87,},
  /* 72: */ {88,},
  /* 73: */ {},
  /* 74: */ {},
  /* 75: */ {},
  /* 76: */ {},
  /* 77: */ {},
  /* 78: */ {},
  /* 79: */ {},
  /* 80: */ {},
  /* 81: */ {},
  /* 82: */ {},
  /* 83: */ {},
  /* 84: */ {},
  /* 85: */ {},
  /* 86: */ {},
  /* 87: */ {},
  /* 88: */ {},
  /* 89: */ {},
    };
  };

  public String[] getRegsetName() {
    return new String[] {
      "*reg-rax-I64*",
      "*reg-rcx-I64*",
      "*reg-rdx-I64*",
      "*reg-rbx-I64*",
      "*reg-eax-I32*",
      "*reg-ecx-I32*",
      "*reg-edx-I32*",
      "*reg-ax-I16*",
      "*reg-cx-I16*",
      "*reg-al-I8*",
      "*reg-cl-I8*",
      "*reg-I64*",
      "*reg-I32*",
      "*reg-I16*",
      "*reg-I8*",
      "*reg-F64*",
      "*reg-F32*",
      "*reg-call-clobbers*",
      "*reg-callee-saves*",
      "*reg-not-edx-I32*",
      "*reg-not-rdx-I64*",
      "*reg-not-eax-I32*",
    };
  };
  public int[] getRegsetNumber() {
    return new int[] {
      1,
      2,
      3,
      10,
      15,
      16,
      17,
      29,
      30,
      43,
      44,
      90,
      91,
      92,
      93,
      94,
      95,
      96,
      97,
      98,
      99,
      100,
    };
  };
  public short[][] getRegsetMap() {
    return new short[][] {
      {1,2,3,4,5,6,7,8,9,10,11,12,13,14,},
      {15,16,17,18,19,20,21,22,23,24,25,26,27,28,},
      {29,30,31,32,33,34,35,36,37,38,39,40,41,42,},
      {43,44,45,46,47,48,49,50,51,52,53,54,55,56,},
      {57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,},
      {73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,},
      {1,2,3,4,5,6,7,8,9,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,},
      {10,11,12,13,14,89,},
      {15,16,18,19,20,21,22,23,24,25,26,27,28,},
      {1,2,4,5,6,7,8,9,10,11,12,13,14,},
      {16,17,18,19,20,21,22,23,24,25,26,27,28,},
      {1,2,3,4,5,6,7,8,9,},
      {10,11,12,13,14,},
      {1,2,4,5,6,7,8,9,},
      {16,18,19,20,21,22,23,24,25,26,27,28,},
    };
  };

  public short[] getRegsetNAvail() {
    return new short[] {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      14, 14, 14, 14, 16, 16, 25, 6, 13, 13, 
      13, 9, 5, 8, 12,     };
  };

  public int[] getCompAndTbl() {
    return new int[] {
      -4006,1,2,3,4,5,6,7,8,9,10,11,12,13,14,
      -4110,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
      -4215,29,30,31,32,33,34,35,36,37,38,39,40,41,42,
      -4321,43,44,45,46,47,48,49,50,51,52,53,54,55,56,
      -4428,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
      -4538,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,
      -4561,1,2,3,4,5,6,7,8,9,
      -4617,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
      -4650,101,
      -4654,94,
      -4666,10,11,12,13,14,
      -4745,89,102,
      -4768,15,16,
      -4771,18,19,20,21,22,23,24,25,26,27,28,
      -4844,98,
      -4852,1,2,
      -4855,4,5,6,7,8,9,10,11,12,13,14,
      -4941,99,
      -4947,103,102,
      -4966,16,17,18,19,20,21,22,23,24,25,26,27,28,
      -5041,100,
      -5048,104,
      -5051,1,2,3,4,5,6,7,8,9,
      -5140,101,
      -5146,101,
      -5149,103,
      -5161,10,11,12,13,14,
      -5241,102,
      -5248,102,
      -5250,102,
      -5254,1,2,
      -5257,4,5,6,7,8,9,
      -5343,103,
      -5349,103,
      -5352,103,
      -5354,103,
      -5372,16,
      -5374,18,19,20,21,22,23,24,25,26,27,28,
      -5447,104,
      -5454,104,
      -5456,104,
    };
  };

  public int[] getCompWeightTbl() {
    return new int[] {
    106,65,
    120,65,
    134,65,
    148,65,
    195,257,
    201,65,
    203,129,
    206,65,
    208,65,
    212,65,
    226,65,
    240,65,
    254,65,
    300,257,
    306,65,
    308,257,
    313,129,
    318,65,
    332,65,
    346,65,
    360,65,
    405,257,
    411,65,
    415,129,
    424,65,
    438,65,
    452,65,
    466,65,
    510,257,
    516,65,
    518,257,
    523,129,
    530,65,
    544,65,
    558,65,
    572,65,
    615,257,
    621,65,
    623,257,
    628,129,
    636,65,
    650,65,
    664,65,
    678,65,
    720,257,
    726,65,
    728,257,
    733,129,
    742,65,
    756,65,
    770,65,
    784,65,
    825,257,
    831,65,
    833,257,
    838,129,
    848,65,
    862,65,
    876,65,
    890,65,
    930,257,
    936,65,
    938,257,
    943,129,
    954,65,
    968,65,
    982,65,
    996,65,
    1035,257,
    1041,65,
    1043,257,
    1048,129,
    1060,65,
    1074,65,
    1088,65,
    1102,65,
    1140,257,
    1147,257,
    1152,65,
    1154,65,
    1166,65,
    1180,65,
    1194,65,
    1208,65,
    1245,257,
    1252,257,
    1257,65,
    1259,65,
    1272,65,
    1286,65,
    1300,65,
    1314,65,
    1350,257,
    1357,257,
    1362,65,
    1364,65,
    1378,65,
    1392,65,
    1406,65,
    1420,65,
    1455,257,
    1462,257,
    1467,65,
    1469,65,
    1484,65,
    1498,65,
    1512,65,
    1526,65,
    1560,257,
    1567,257,
    1572,65,
    1574,65,
    1576,65,
    1590,65,
    1604,65,
    1618,65,
    1665,257,
    1671,65,
    1673,129,
    1676,65,
    1678,65,
    1682,65,
    1696,65,
    1710,65,
    1724,65,
    1770,257,
    1776,65,
    1778,257,
    1783,129,
    1788,65,
    1802,65,
    1816,65,
    1830,65,
    1875,257,
    1881,65,
    1885,129,
    1894,65,
    1908,65,
    1922,65,
    1936,65,
    1980,257,
    1986,65,
    1988,257,
    1993,129,
    2000,65,
    2014,65,
    2028,65,
    2042,65,
    2085,257,
    2091,65,
    2093,257,
    2098,129,
    2106,65,
    2120,65,
    2134,65,
    2148,65,
    2190,257,
    2196,65,
    2198,257,
    2203,129,
    2212,65,
    2226,65,
    2240,65,
    2254,65,
    2295,257,
    2301,65,
    2303,257,
    2308,129,
    2318,65,
    2332,65,
    2346,65,
    2360,65,
    2400,257,
    2406,65,
    2408,257,
    2413,129,
    2424,65,
    2438,65,
    2452,65,
    2466,65,
    2505,257,
    2511,65,
    2513,257,
    2518,129,
    2530,65,
    2544,65,
    2558,65,
    2572,65,
    2610,257,
    2617,257,
    2622,65,
    2624,65,
    2636,65,
    2650,65,
    2664,65,
    2678,65,
    2715,257,
    2722,257,
    2727,65,
    2729,65,
    2742,65,
    2756,65,
    2770,65,
    2784,65,
    2820,257,
    2827,257,
    2832,65,
    2834,65,
    2848,65,
    2862,65,
    2876,65,
    2890,65,
    2925,257,
    2932,257,
    2937,65,
    2939,65,
    2954,65,
    2968,65,
    2982,65,
    2996,65,
    3030,257,
    3037,257,
    3042,65,
    3044,65,
    3046,65,
    3060,65,
    3074,65,
    3088,65,
    3135,257,
    3141,65,
    3143,129,
    3146,65,
    3148,65,
    3152,65,
    3166,65,
    3180,65,
    3194,65,
    3240,257,
    3246,65,
    3248,257,
    3253,129,
    3258,65,
    3272,65,
    3286,65,
    3300,65,
    3345,257,
    3351,65,
    3355,129,
    3364,65,
    3378,65,
    3392,65,
    3406,65,
    3450,257,
    3456,65,
    3458,257,
    3463,129,
    3470,65,
    3484,65,
    3498,65,
    3512,65,
    3555,257,
    3561,65,
    3563,257,
    3568,129,
    3576,65,
    3590,65,
    3604,65,
    3618,65,
    3660,257,
    3666,65,
    3668,257,
    3673,129,
    3682,65,
    3696,65,
    3710,65,
    3724,65,
    3765,257,
    3771,65,
    3773,257,
    3778,129,
    3788,65,
    3802,65,
    3816,65,
    3830,65,
    3870,257,
    3876,65,
    3878,257,
    3883,129,
    3894,65,
    3908,65,
    3922,65,
    3936,65,
    3975,257,
    3981,65,
    3983,257,
    3988,129,
    4000,65,
    4014,65,
    4028,65,
    4042,65,
    4080,257,
    4087,257,
    4092,65,
    4094,65,
    4106,65,
    4120,65,
    4134,65,
    4148,65,
    4185,257,
    4192,257,
    4197,65,
    4199,65,
    4212,65,
    4226,65,
    4240,65,
    4254,65,
    4290,257,
    4297,257,
    4302,65,
    4304,65,
    4318,65,
    4332,65,
    4346,65,
    4360,65,
    4395,257,
    4402,257,
    4407,65,
    4409,65,
    4424,65,
    4438,65,
    4452,65,
    4466,65,
    4500,257,
    4507,257,
    4512,65,
    4514,65,
    4516,65,
    4530,65,
    4544,65,
    4558,65,
    4605,257,
    4611,65,
    4613,129,
    4616,65,
    4618,65,
    4622,65,
    4636,65,
    4650,65,
    4664,65,
    4710,257,
    4716,65,
    4718,257,
    4723,129,
    4728,65,
    4742,65,
    4756,65,
    4770,65,
    4815,257,
    4821,65,
    4825,129,
    4834,65,
    4848,65,
    4862,65,
    4876,65,
    4920,257,
    4926,65,
    4928,257,
    4933,129,
    4940,65,
    4954,65,
    4968,65,
    4982,65,
    5025,257,
    5031,65,
    5033,257,
    5038,129,
    5046,65,
    5060,65,
    5074,65,
    5088,65,
    5130,257,
    5136,65,
    5138,257,
    5143,129,
    5152,65,
    5166,65,
    5180,65,
    5194,65,
    5235,257,
    5241,65,
    5243,257,
    5248,129,
    5258,65,
    5272,65,
    5286,65,
    5300,65,
    5340,257,
    5346,65,
    5348,257,
    5353,129,
    5364,65,
    5378,65,
    5392,65,
    5406,65,
    5445,257,
    5451,65,
    5453,257,
    5458,129,
    5470,65,
    5484,65,
    5498,65,
    5512,65,
    5550,257,
    5557,257,
    5562,65,
    5564,65,
    5576,65,
    5590,65,
    5604,65,
    5618,65,
    5655,257,
    5662,257,
    5667,65,
    5669,65,
    5682,65,
    5696,65,
    5710,65,
    5724,65,
    5760,257,
    5767,257,
    5772,65,
    5774,65,
    5788,65,
    5802,65,
    5816,65,
    5830,65,
    5865,257,
    5872,257,
    5877,65,
    5879,65,
    5894,65,
    5908,65,
    5922,65,
    5936,65,
    5970,257,
    5977,257,
    5982,65,
    5984,65,
    6042,65,
    6058,65,
    6079,193,
    6148,65,
    6164,65,
    6184,193,
    6254,65,
    6270,65,
    6289,193,
    6360,65,
    6376,65,
    6394,193,
    6466,65,
    6482,65,
    6499,193,
    6572,65,
    6588,65,
    6604,193,
    6678,65,
    6694,65,
    6709,193,
    6784,65,
    6800,65,
    6814,193,
    6890,65,
    6906,65,
    6919,193,
    6996,65,
    7012,65,
    7024,193,
    7102,65,
    7118,65,
    7129,193,
    7208,65,
    7224,65,
    7234,193,
    7314,65,
    7330,65,
    7339,193,
    7420,65,
    7436,65,
    7444,193,
    7526,65,
    7542,65,
    7549,193,
    7632,65,
    7648,65,
    7654,193,
    7722,65,
    7738,65,
    7759,193,
    7828,65,
    7844,65,
    7864,193,
    7934,65,
    7950,65,
    7969,193,
    8040,65,
    8056,65,
    8074,193,
    8146,65,
    8162,65,
    8179,193,
    8252,65,
    8268,65,
    8284,193,
    8358,65,
    8374,65,
    8389,193,
    8464,65,
    8480,65,
    8494,193,
    8570,65,
    8586,65,
    8599,193,
    8676,65,
    8692,65,
    8704,193,
    8782,65,
    8798,65,
    8809,193,
    8888,65,
    8904,65,
    8914,193,
    8994,65,
    9010,65,
    9019,193,
    9100,65,
    9116,65,
    9124,193,
    9206,65,
    9222,65,
    9229,193,
    9312,65,
    9328,65,
    9334,193,
    9434,65,
    9442,65,
    9451,3585,
    9540,257,
    9546,577,
    9556,3585,
    9645,257,
    9651,577,
    9661,3585,
    9750,257,
    9756,577,
    9766,3585,
    9855,257,
    9861,577,
    9927,2049,
    9964,193,
    10032,2049,
    10069,193,
    10081,577,
    10095,577,
    10109,577,
    10123,577,
    10137,2049,
    10170,449,
    10178,257,
    10183,129,
    10195,321,
    10209,321,
    10223,321,
    10237,321,
    10274,321,
    10282,257,
    10287,65,
    10289,65,
    10291,129,
    10294,833,
    10308,833,
    10322,833,
    10336,705,
    10380,257,
    10386,577,
    10396,129,
    10399,833,
    10413,833,
    10427,833,
    10441,705,
    10485,257,
    10491,577,
    10502,833,
    10516,833,
    10530,833,
    10544,833,
    10590,257,
    10596,577,
    10606,577,
    10620,577,
    10634,577,
    10648,577,
    10695,257,
    10701,65,
    10703,257,
    10708,129,
    10720,321,
    10734,321,
    10748,321,
    10762,321,
    10800,257,
    10807,257,
    10812,65,
    10814,65,
    10816,129,
    10819,385,
    10830,129,
    10833,385,
    10844,129,
    10847,385,
    10858,129,
    10861,385,
    10905,257,
    10911,65,
    10913,257,
    10918,129,
    10922,65,
    10924,705,
    10936,65,
    10938,705,
    10950,65,
    10952,705,
    10964,65,
    10966,705,
    11010,257,
    11016,577,
    };
  };

  public int[] getRegsetTypeTbl() {
    return new int[] {
    -1,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    1026,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    514,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    258,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    1026,
    1026,
    514,
    258,
    130,
    1028,
    516,
    1026,
    1026,
    514,
    1026,
    514,
    1026,
    1026,
    1026,
    514,
    };
  }
}
