/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHCastExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.UtilEvalError;
import java.lang.reflect.Array;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int n) {
        super(n);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.", this, callStack);
    }

    public Object eval(Class clazz, int n, CallStack callStack, Interpreter interpreter) throws EvalError {
        int n2 = this.jjtGetNumChildren();
        int[] nArray = new int[n];
        nArray[0] = n2;
        Object object2 = Array.newInstance(clazz, nArray);
        int n3 = 0;
        while (n3 < n2) {
            Object object3;
            Object object4;
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(n3);
            if (simpleNode instanceof BSHArrayInitializer) {
                if (n < 2) {
                    throw new EvalError("Invalid Location for Intializer, position: " + n3, this, callStack);
                }
                object4 = ((BSHArrayInitializer)simpleNode).eval(clazz, n - 1, callStack, interpreter);
            } else {
                object4 = simpleNode.eval(callStack, interpreter);
            }
            if (object4 == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position" + n3, this, callStack);
            }
            if (object4 instanceof Primitive) {
                Primitive primitive = (Primitive)object4;
                if (clazz.isPrimitive()) {
                    try {
                        primitive = BSHCastExpression.castPrimitive(primitive, clazz);
                    }
                    catch (UtilEvalError utilEvalError) {
                        utilEvalError.printStackTrace();
                        Interpreter.debug("error:" + utilEvalError);
                        this.throwTypeError(clazz, primitive, n3, callStack);
                    }
                }
                object3 = primitive.getValue();
            } else {
                object3 = object4;
            }
            try {
                Array.set(object2, n3, object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Interpreter.debug("illegal arg" + illegalArgumentException);
                this.throwTypeError(clazz, object4, n3, callStack);
            }
            catch (ArrayStoreException arrayStoreException) {
                Interpreter.debug("arraystore" + arrayStoreException);
                this.throwTypeError(clazz, object4, n3, callStack);
            }
            ++n3;
        }
        return object2;
    }

    private void throwTypeError(Class clazz, Object object2, int n, CallStack callStack) throws EvalError {
        String string = Reflect.normalizeClassName(clazz);
        String string2 = object2 instanceof Primitive ? ((Primitive)object2).getType().getName() : Reflect.normalizeClassName(object2.getClass());
        throw new EvalError("Incompatible type: " + string2 + " in initializer of array type: " + clazz + " at position: " + n, this, callStack);
    }
}

