/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.barbecue.Barcode;

public final class BarcodeImageHandler {
    private BarcodeImageHandler() {
    }

    public static BufferedImage getImage(Barcode barcode) {
        BufferedImage bufferedImage = new BufferedImage(barcode.getWidth(), barcode.getHeight(), 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        barcode.draw(graphics2D, 0, 0);
        bufferedImage.flush();
        return bufferedImage;
    }

    public static void outputBarcodeAsJPEGImage(Barcode barcode, OutputStream outputStream) throws IOException {
        BarcodeImageHandler.outputImage(barcode, outputStream);
    }

    private static void outputImage(Barcode barcode, OutputStream outputStream) throws IOException {
        BufferedImage bufferedImage = BarcodeImageHandler.getImage(barcode);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        jPEGImageEncoder.encode(bufferedImage, jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage));
    }
}

