/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAttachment;
import org.compiere.model.MNote;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class NoteServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "NoteServlet";
    public static final String P_Note_ID = "AD_Note_ID";
    public static final String P_ATTACHMENT_INDEX = "AttachmentIndex";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("NoteServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Note Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        String url = "/notes.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            String msg;
            session.removeAttribute("hdrMessage");
            WebInfo info = (WebInfo)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            if ((msg = this.streamAttachment(request, response)) == null || msg.length() == 0) {
                return;
            }
            if (info != null) {
                info.setMessage(msg);
            }
        }
        this.log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String streamAttachment(HttpServletRequest request, HttpServletResponse response) {
        int AD_Note_ID = WebUtil.getParameterAsInt(request, P_Note_ID);
        if (AD_Note_ID == 0) {
            this.log.fine("No AD_Note_ID)");
            return "No Notice ID";
        }
        int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
        if (attachmentIndex == 0) {
            this.log.fine("No index)");
            return "No Request Attachment index";
        }
        this.log.info("AD_Notice_ID=" + AD_Note_ID + " / " + attachmentIndex);
        Ctx ctx = JSPEnv.getCtx(request);
        MNote doc = new MNote(ctx, AD_Note_ID, null);
        if (doc.getAD_Note_ID() != AD_Note_ID) {
            this.log.fine("Note not found - ID=" + AD_Note_ID);
            return "Notice not found";
        }
        MAttachment attachment = doc.getAttachment(false);
        if (attachment == null) {
            this.log.fine("No Attachment for AD_Note_ID=" + AD_Note_ID);
            return "Notice Attachment not found";
        }
        HttpSession session = request.getSession(true);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu.getAD_User_ID() != doc.getAD_User_ID()) {
            this.log.warning("AD_Note_ID=" + AD_Note_ID + " - User_ID=" + doc.getAD_User_ID() + " = Web_User=" + wu.getAD_User_ID());
            return "Your Notice not found";
        }
        return WebUtil.streamAttachment(response, attachment, attachmentIndex);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        MNote note;
        boolean prc;
        this.log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        String url = "/notes.jsp";
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Ctx ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            this.log.warning("No web user");
            if (!response.isCommitted()) {
                response.sendRedirect("loginServlet?ForwardTo=notes.jsp");
            }
            return;
        }
        WebEnv.dump(request);
        int AD_Note_ID = WebUtil.getParameterAsInt(request, P_Note_ID);
        String processed = WebUtil.getParameter(request, "Processed");
        boolean bl = prc = processed != null && processed.length() > 0;
        if (prc && (note = new MNote(ctx, AD_Note_ID, null)).get_ID() == AD_Note_ID) {
            note.setProcessed(true);
            note.save();
            this.log.fine("doPost - " + note);
        }
        this.log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

