/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.lindfors.util;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class LocalizationSupport {
    private Locale locale = Locale.getDefault();
    private ResourceBundle bundle = null;

    public LocalizationSupport(String string, Locale locale) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("bundle name was null");
        }
        if (locale != null) {
            this.locale = locale;
        }
        try {
            this.bundle = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Could not find the language package!");
            this.bundle = this.createDummyBundle();
        }
    }

    public String getString(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "<undefined>";
        }
    }

    public String getLabel(String string) {
        try {
            return this.bundle.getString("label." + string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                return "<undefined>";
            }
        }
    }

    public String getTooltip(String string) {
        try {
            return this.bundle.getString("tooltip." + string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                return "";
            }
        }
    }

    public String getShortcut(String string) {
        return "";
    }

    public Integer getMnemonic(String string) {
        return new Integer(0);
    }

    public String getContextHelp(String string) {
        try {
            return this.bundle.getString("ctxhelp." + string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                return "Context help not available.";
            }
        }
    }

    private ResourceBundle createDummyBundle() {
        return new ResourceBundle(){
            private Vector noKeys = new Vector();

            public Enumeration getKeys() {
                return this.noKeys.elements();
            }

            protected Object handleGetObject(String string) {
                return "<lang-pkg not found>";
            }
        };
    }
}

