/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.statistics;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReplicationStatistics
implements Serializable {
    private static final long serialVersionUID = 9153807780893455734L;
    private ConcurrentReaderHashMap ctxStats;
    public long lastResetTime = System.currentTimeMillis();

    public ReplicationStatistics() {
        this.ctxStats = new ConcurrentReaderHashMap();
    }

    public void updatePassivationStats(String ctx, long elapsed) {
        TimeStatistic stat = (TimeStatistic)this.ctxStats.get((Object)ctx);
        if (stat == null) {
            stat = new TimeStatistic();
            this.ctxStats.put((Object)ctx, (Object)stat);
        }
        stat.totalPassivationTime += elapsed;
        if (stat.minPassivationTime > elapsed) {
            stat.minPassivationTime = elapsed;
        }
        if (stat.maxPassivationTime < elapsed) {
            stat.maxPassivationTime = elapsed;
        }
    }

    public void updateReplicationStats(String ctx, long elapsed) {
        TimeStatistic stat = (TimeStatistic)this.ctxStats.get((Object)ctx);
        if (stat == null) {
            stat = new TimeStatistic();
            this.ctxStats.put((Object)ctx, (Object)stat);
        }
        ++stat.replicationCount;
        stat.totalReplicationlTime += elapsed;
        if (stat.minReplicationTime > elapsed) {
            stat.minReplicationTime = elapsed;
        }
        if (stat.maxReplicationTime < elapsed) {
            stat.maxReplicationTime = elapsed;
        }
    }

    public void updateLoadStats(String ctx, long elapsed) {
        TimeStatistic stat = (TimeStatistic)this.ctxStats.get((Object)ctx);
        if (stat == null) {
            stat = new TimeStatistic();
            this.ctxStats.put((Object)ctx, (Object)stat);
        }
        ++stat.loadCount;
        stat.totalLoadlTime += elapsed;
        if (stat.minLoadTime > elapsed) {
            stat.minLoadTime = elapsed;
        }
        if (stat.maxLoadTime < elapsed) {
            stat.maxLoadTime = elapsed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.ctxStats;
        synchronized (concurrentReaderHashMap) {
            Iterator iter = this.ctxStats.values().iterator();
            while (iter.hasNext()) {
                TimeStatistic stat = (TimeStatistic)iter.next();
                stat.reset();
            }
        }
        this.lastResetTime = System.currentTimeMillis();
    }

    public void removeStats(String id) {
        this.ctxStats.remove((Object)id);
    }

    public Map getStats() {
        return this.ctxStats;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        HashMap copy = new HashMap(this.ctxStats);
        Iterator iter = copy.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TimeStatistic stat = (TimeStatistic)entry.getValue();
            tmp.append("[sessionID: ");
            tmp.append(entry.getKey());
            tmp.append(", replicationCount=");
            tmp.append(stat.replicationCount);
            tmp.append(", minPassivationTime=");
            tmp.append(stat.minPassivationTime);
            tmp.append(", maxPassivationTime=");
            tmp.append(stat.maxPassivationTime);
            tmp.append(", totalPassivationTime=");
            tmp.append(stat.totalPassivationTime);
            tmp.append(", minReplicationTime=");
            tmp.append(stat.minReplicationTime);
            tmp.append(", maxReplicationTime=");
            tmp.append(stat.maxReplicationTime);
            tmp.append(", totalReplicationlTime=");
            tmp.append(stat.totalReplicationlTime);
            tmp.append(", loadCount=");
            tmp.append(stat.loadCount);
            tmp.append(", minLoadTime=");
            tmp.append(stat.minLoadTime);
            tmp.append(", maxLoadTime=");
            tmp.append(stat.maxLoadTime);
            tmp.append(", totaLoadlTime=");
            tmp.append(stat.totalLoadlTime);
            tmp.append("];");
        }
        tmp.append(")");
        return tmp.toString();
    }

    public static class TimeStatistic {
        public long replicationCount;
        public long minPassivationTime = Long.MAX_VALUE;
        public long maxPassivationTime;
        public long totalPassivationTime;
        public long minReplicationTime = Long.MAX_VALUE;
        public long maxReplicationTime;
        public long totalReplicationlTime;
        public long loadCount;
        public long minLoadTime = Long.MAX_VALUE;
        public long maxLoadTime;
        public long totalLoadlTime;

        public void reset() {
            this.replicationCount = 0L;
            this.minPassivationTime = Long.MAX_VALUE;
            this.maxPassivationTime = 0L;
            this.totalPassivationTime = 0L;
            this.minReplicationTime = Long.MAX_VALUE;
            this.maxReplicationTime = 0L;
            this.totalReplicationlTime = 0L;
            this.loadCount = 0L;
            this.minLoadTime = Long.MAX_VALUE;
            this.maxLoadTime = 0L;
            this.totalLoadlTime = 0L;
        }
    }
}

