/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB;
    private static final int PROG = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap() {
        Vector<MailcapFile> dbv = new Vector<MailcapFile>(5);
        MailcapFile mf = null;
        dbv.addElement(null);
        LogSupport.log((String)"MailcapCommandMap: load HOME");
        try {
            String path;
            String user_home = System.getProperty("user.home");
            if (user_home != null && (mf = this.loadFile(path = user_home + File.separator + ".mailcap")) != null) {
                dbv.addElement(mf);
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        LogSupport.log((String)"MailcapCommandMap: load SYS");
        try {
            String system_mailcap = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mailcap";
            mf = this.loadFile(system_mailcap);
            if (mf != null) {
                dbv.addElement(mf);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log((String)"MailcapCommandMap: load JAR");
        this.loadAllResources(dbv, "META-INF/mailcap");
        LogSupport.log((String)"MailcapCommandMap: load DEF");
        Class clazz = MailcapCommandMap.class;
        synchronized (clazz) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
        }
        if (defDB != null) {
            dbv.addElement(defDB);
        }
        this.DB = new MailcapFile[dbv.size()];
        dbv.copyInto(this.DB);
    }

    public MailcapCommandMap(InputStream is) {
        this();
        LogSupport.log((String)"MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public MailcapCommandMap(String fileName) throws IOException {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log((String)("MailcapCommandMap: load PROG from " + fileName));
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(fileName);
        }
    }

    public synchronized void addMailcap(String mail_cap) {
        LogSupport.log((String)"MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(mail_cap);
    }

    private MailcapFile loadFile(String name) {
        MailcapFile mtf = null;
        try {
            mtf = new MailcapFile(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mtf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private MailcapFile loadResource(String name) {
        block23: {
            InputStream clis;
            block22: {
                block20: {
                    clis = null;
                    clis = SecuritySupport.getInstance().getResourceAsStream(this.getClass(), name);
                    if (clis == null) break block20;
                    MailcapFile mf = new MailcapFile(clis);
                    if (LogSupport.isLoggable()) {
                        LogSupport.log((String)("MailcapCommandMap: successfully loaded mailcap file: " + name));
                    }
                    MailcapFile mailcapFile = mf;
                    Object var6_7 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    return mailcapFile;
                }
                if (!LogSupport.isLoggable()) break block22;
                LogSupport.log((String)("MailcapCommandMap: not loading mailcap file: " + name));
            }
            Object var6_8 = null;
            try {
                if (clis != null) {
                    clis.close();
                }
                break block23;
            }
            catch (IOException ex) {}
            break block23;
            {
                catch (IOException e) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log((String)("MailcapCommandMap: can't load " + name), (Throwable)e);
                    }
                    Object var6_9 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                        break block23;
                    }
                    catch (IOException ex) {}
                    break block23;
                }
                catch (SecurityException sex) {
                    if (LogSupport.isLoggable()) {
                        LogSupport.log((String)("MailcapCommandMap: can't load " + name), (Throwable)sex);
                    }
                    Object var6_10 = null;
                    try {
                        if (clis != null) {
                            clis.close();
                        }
                        break block23;
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (clis != null) {
                        clis.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadAllResources(Vector v, String name) {
        boolean anyLoaded;
        block24: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getInstance().getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getInstance().getResources(cld, name) : SecuritySupport.getInstance().getSystemResources(name)) == null) break block24;
                if (LogSupport.isLoggable()) {
                    LogSupport.log((String)"MailcapCommandMap: getResources");
                }
                for (int i = 0; i < urls.length; ++i) {
                    InputStream clis;
                    URL url;
                    block25: {
                        url = urls[i];
                        clis = null;
                        if (LogSupport.isLoggable()) {
                            LogSupport.log((String)("MailcapCommandMap: URL " + url));
                        }
                        clis = SecuritySupport.getInstance().openStream(url);
                        if (clis != null) {
                            v.addElement(new MailcapFile(clis));
                            anyLoaded = true;
                            if (LogSupport.isLoggable()) {
                                LogSupport.log((String)("MailcapCommandMap: successfully loaded mailcap file from URL: " + url));
                            }
                            break block25;
                        }
                        if (!LogSupport.isLoggable()) break block25;
                        LogSupport.log((String)("MailcapCommandMap: not loading mailcap file from URL: " + url));
                    }
                    Object var11_13 = null;
                    try {
                        if (clis == null) continue;
                        clis.close();
                    }
                    catch (IOException cex) {}
                    continue;
                    {
                        catch (IOException ioex) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log((String)("MailcapCommandMap: can't load " + url), (Throwable)ioex);
                            }
                            var11_13 = null;
                            try {
                                if (clis == null) continue;
                                clis.close();
                            }
                            catch (IOException cex) {}
                            continue;
                        }
                        catch (SecurityException sex) {
                            if (LogSupport.isLoggable()) {
                                LogSupport.log((String)("MailcapCommandMap: can't load " + url), (Throwable)sex);
                            }
                            var11_13 = null;
                            try {
                                if (clis == null) continue;
                                clis.close();
                            }
                            catch (IOException cex) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var11_13 = null;
                        try {
                            if (clis != null) {
                                clis.close();
                            }
                        }
                        catch (IOException cex) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            catch (Exception ex) {
                if (!LogSupport.isLoggable()) break block24;
                LogSupport.log((String)("MailcapCommandMap: can't load " + name), (Throwable)ex);
            }
        }
        if (!anyLoaded) {
            MailcapFile mf;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)"MailcapCommandMap: !anyLoaded");
            }
            if ((mf = this.loadResource("/" + name)) != null) {
                v.addElement(mf);
            }
        }
    }

    private boolean checkForVerb(Vector cmdVector, String verb) {
        Enumeration enumeration = cmdVector.elements();
        while (enumeration.hasMoreElements()) {
            String enum_verb = ((CommandInfo)enumeration.nextElement()).getCommandName();
            if (!enum_verb.equals(verb)) continue;
            return true;
        }
        return false;
    }

    private void appendCmdsToVector(Hashtable typeHash, Vector cmdList) {
        Enumeration verb_enum = typeHash.keys();
        while (verb_enum.hasMoreElements()) {
            String verb = (String)verb_enum.nextElement();
            Vector cmdVector = (Vector)typeHash.get(verb);
            Enumeration cmd_enum = cmdVector.elements();
            while (cmd_enum.hasMoreElements()) {
                String cmd = (String)cmd_enum.nextElement();
                cmdList.insertElementAt(new CommandInfo(verb, cmd), 0);
            }
        }
    }

    private void appendPrefCmdsToVector(Hashtable typeHash, Vector cmdList) {
        Enumeration verb_enum = typeHash.keys();
        while (verb_enum.hasMoreElements()) {
            String verb = (String)verb_enum.nextElement();
            if (this.checkForVerb(cmdList, verb)) continue;
            Vector cmdVector = (Vector)typeHash.get(verb);
            String className = (String)cmdVector.firstElement();
            cmdList.addElement(new CommandInfo(verb, className));
        }
    }

    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        Vector cmdVector = new Vector();
        for (int i = 0; i < this.DB.length; ++i) {
            Hashtable cmdList;
            if (this.DB[i] == null || (cmdList = this.DB[i].getMailcapList(mimeType)) == null) continue;
            this.appendCmdsToVector(cmdList, cmdVector);
        }
        Object[] cmdInfos = new CommandInfo[cmdVector.size()];
        cmdVector.copyInto(cmdInfos);
        return cmdInfos;
    }

    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        Vector cmdVector = new Vector();
        for (int i = 0; i < this.DB.length; ++i) {
            Hashtable cmdList;
            if (this.DB[i] == null || (cmdList = this.DB[i].getMailcapList(mimeType)) == null) continue;
            this.appendPrefCmdsToVector(cmdList, cmdVector);
        }
        Object[] cmdInfos = new CommandInfo[cmdVector.size()];
        cmdVector.copyInto(cmdInfos);
        return cmdInfos;
    }

    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        if (LogSupport.isLoggable()) {
            LogSupport.log((String)("MailcapCommandMap: createDataContentHandler for " + mimeType));
        }
        for (int i = 0; i < this.DB.length; ++i) {
            Vector v;
            Hashtable cmdList;
            if (this.DB[i] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("  search DB #" + i));
            }
            if ((cmdList = this.DB[i].getMailcapList(mimeType)) == null || (v = (Vector)cmdList.get("content-handler")) == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)"    got content-handler");
            }
            String name = (String)v.firstElement();
            if (LogSupport.isLoggable()) {
                LogSupport.log((String)("      class " + name));
            }
            try {
                ClassLoader cld = null;
                cld = SecuritySupport.getInstance().getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                Class<?> cl = null;
                try {
                    cl = cld.loadClass(name);
                }
                catch (Exception ex) {
                    cl = Class.forName(name);
                }
                if (cl == null) continue;
                return (DataContentHandler)cl.newInstance();
            }
            catch (IllegalAccessException e) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log((String)("Can't load DCH " + name), (Throwable)e);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log((String)("Can't load DCH " + name), (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                if (!LogSupport.isLoggable()) continue;
                LogSupport.log((String)("Can't load DCH " + name), (Throwable)e);
            }
        }
        return null;
    }

    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        for (int i = 0; i < this.DB.length; ++i) {
            String cmdClassName;
            Vector v;
            Hashtable cmdList;
            if (this.DB[i] == null || (cmdList = this.DB[i].getMailcapList(mimeType)) == null || (v = (Vector)cmdList.get(cmdName)) == null || (cmdClassName = (String)v.firstElement()) == null) continue;
            return new CommandInfo(cmdName, cmdClassName);
        }
        return null;
    }
}

