/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.ZipEntry;
import org.compiere.framework.VO;
import org.compiere.install.ComponentFileFilter;
import org.compiere.util.CLogger;
import org.compiere.util.Util;
import org.compiere.util.ZipUtil;

public class ComponentInfo {
    private File m_componentFile;
    private boolean m_valid = false;
    private boolean m_accepted = false;
    private String m_name = null;
    private String m_version = null;
    private String m_license = null;
    private byte[] m_logo = null;
    protected CLogger s_log = CLogger.getCLogger(ComponentInfo.class);

    public static ComponentInfo[] getComponents(String compiereHome) {
        File dataDir = new File(compiereHome + File.separator + "data");
        if (dataDir.exists()) {
            String[] fileNames = dataDir.list(new ComponentFileFilter());
            ComponentInfo[] retValue = new ComponentInfo[fileNames.length];
            for (int i = 0; i < fileNames.length; ++i) {
                retValue[i] = new ComponentInfo(new File(dataDir, fileNames[i]));
            }
            return retValue;
        }
        return null;
    }

    public ComponentInfo(File file) {
        this.init(file);
    }

    private void init(File file) {
        this.m_componentFile = file;
        if (!this.m_componentFile.exists()) {
            this.s_log.warning("Not found: " + file);
            return;
        }
        try {
            ZipUtil zip = new ZipUtil(this.m_componentFile);
            ZipEntry entry = zip.getEntry("EntityType_VO");
            if (entry == null) {
                this.s_log.warning("EntityType_VO not found: " + this.m_componentFile);
                return;
            }
            InputStream in = zip.getInputStream(entry);
            ObjectInputStream oIn = new ObjectInputStream(in);
            Object obj = oIn.readObject();
            if (obj instanceof VO) {
                VO vo = (VO)obj;
                this.m_name = vo.get("Name");
                String et = vo.get("EntityType");
                if ("D".equals(et)) {
                    this.m_name = "Compiere Core";
                }
                this.m_version = vo.get("Version");
                this.m_license = vo.get("LicenseText");
                String data = vo.get("BinaryData");
                if (data != null) {
                    this.m_logo = Util.toByteArray(data);
                }
                this.m_valid = true;
            }
            this.m_accepted = this.m_license == null;
        }
        catch (Exception e) {
            this.m_valid = false;
        }
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public String getFileName() {
        if (this.m_componentFile == null) {
            return null;
        }
        return this.m_componentFile.getAbsolutePath();
    }

    public String getLicense() {
        return this.m_license;
    }

    public String getLicenseFileName() {
        StringBuffer sb = new StringBuffer(this.m_name);
        if (this.m_version != null && this.m_version.length() > 0) {
            sb.append(" ").append(this.m_version);
        }
        sb.append(" license.html");
        Util.replace(sb, " ", "_");
        return sb.toString();
    }

    public String getHeading() {
        StringBuffer sb = new StringBuffer();
        if (this.m_name != null) {
            sb.append(this.m_name);
        } else {
            sb.append(this.getFileName());
        }
        if (this.m_version != null) {
            sb.append(" ").append(this.m_version);
        }
        return sb.toString();
    }

    public void setLicenseAccepted(boolean accepted) {
        this.m_accepted = accepted;
    }

    public byte[] getLogo() {
        return this.m_logo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.m_name != null) {
            sb.append(this.m_name);
        } else {
            sb.append(this.getFileName());
        }
        if (this.m_version != null) {
            sb.append(" ").append(this.m_version);
        }
        if (!this.isValid()) {
            sb.append(" ** Not Valid **");
        } else if (!this.m_accepted) {
            sb.append(" {Requires accepting License}");
        }
        return sb.toString();
    }
}

