/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.io.InputStream;
import java.io.Reader;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xml.binding.DelegatingObjectModelFactory;
import org.jboss.xml.binding.GenericObjectModelFactory;
import org.jboss.xml.binding.JBossXBException;
import org.jboss.xml.binding.ObjectModelBuilder;
import org.jboss.xml.binding.ObjectModelFactory;
import org.jboss.xml.binding.parser.JBossXBParser;
import org.jboss.xml.binding.parser.sax.SaxJBossXBParser;
import org.jboss.xml.binding.parser.xni.XniJBossXBParser;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class Unmarshaller {
    private static final Logger log = Logger.getLogger(Unmarshaller.class);
    public static final String VALIDATION = "http://xml.org/sax/features/validation";
    public static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    public static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    public static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    private ObjectModelBuilder builder = new ObjectModelBuilder();
    private final JBossXBParser parser;

    public Unmarshaller() throws JBossXBException {
        this(false);
    }

    public Unmarshaller(boolean useXniParser) throws JBossXBException {
        this.parser = useXniParser ? new XniJBossXBParser() : new SaxJBossXBParser();
        this.parser.setFeature(VALIDATION, true);
        this.parser.setFeature(SCHEMA_VALIDATION, true);
        this.parser.setFeature(SCHEMA_FULL_CHECKING, true);
        this.parser.setFeature(DYNAMIC_VALIDATION, true);
        this.parser.setFeature(NAMESPACES, true);
        this.parser.setEntityResolver((EntityResolver)new JBossEntityResolver());
    }

    public void setValidation(boolean validation) throws JBossXBException {
        this.parser.setFeature(VALIDATION, validation);
    }

    public void setNamespaceAware(boolean namespaces) throws JBossXBException {
        this.parser.setFeature(NAMESPACES, namespaces);
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.parser.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        this.builder.mapFactoryToNamespace(Unmarshaller.getGenericObjectModelFactory(factory), namespaceUri);
    }

    public Object unmarshal(Reader reader, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(Unmarshaller.getGenericObjectModelFactory(factory), root);
        this.parser.parse(reader, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(InputStream is, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(Unmarshaller.getGenericObjectModelFactory(factory), root);
        this.parser.parse(is, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String systemId, ObjectModelFactory factory, Object root) throws JBossXBException {
        this.builder.init(Unmarshaller.getGenericObjectModelFactory(factory), root);
        this.parser.parse(systemId, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(InputSource is, ObjectModelFactory factory, Object root) throws JBossXBException {
        Object result = is.getCharacterStream() != null ? this.unmarshal(is.getCharacterStream(), factory, root) : (is.getByteStream() != null ? this.unmarshal(is.getByteStream(), factory, root) : this.unmarshal(is.getSystemId(), factory, root));
        return result;
    }

    private static final GenericObjectModelFactory getGenericObjectModelFactory(ObjectModelFactory factory) {
        if (!(factory instanceof GenericObjectModelFactory)) {
            factory = new DelegatingObjectModelFactory(factory);
        }
        return factory instanceof GenericObjectModelFactory ? (GenericObjectModelFactory)factory : new DelegatingObjectModelFactory(factory);
    }
}

