/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.management.j2ee;

import java.util.Iterator;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.statistics.Stats;
import org.jboss.logging.Logger;
import org.jboss.management.j2ee.InvalidParentException;
import org.jboss.management.j2ee.J2EEDomain;
import org.jboss.management.j2ee.J2EEManagedObject;
import org.jboss.management.j2ee.J2EEResource;
import org.jboss.management.j2ee.JMSResourceMBean;
import org.jboss.management.j2ee.statistics.JMSStatsImpl;

public class JMSResource
extends J2EEResource
implements JMSResourceMBean {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$management$j2ee$JMSResource == null ? (class$org$jboss$management$j2ee$JMSResource = JMSResource.class$("org.jboss.management.j2ee.JMSResource")) : class$org$jboss$management$j2ee$JMSResource));
    private ObjectName jmsServiceName;
    private JMSStatsImpl stats;
    static /* synthetic */ Class class$org$jboss$management$j2ee$JMSResource;

    public static ObjectName create(MBeanServer mbeanServer, String resName, ObjectName jmsServiceName) {
        ObjectName j2eeServerName = J2EEDomain.getDomainServerName(mbeanServer);
        ObjectName jsr77Name = null;
        try {
            JMSResource jmsRes = new JMSResource(resName, j2eeServerName, jmsServiceName);
            jsr77Name = jmsRes.getObjectName();
            mbeanServer.registerMBean(jmsRes, jsr77Name);
            log.debug((Object)("Created JSR-77 JMSResource: " + resName));
        }
        catch (Exception e) {
            log.debug((Object)("Could not create JSR-77 JMSResource: " + resName), (Throwable)e);
        }
        return jsr77Name;
    }

    public static void destroy(MBeanServer pServer, String pName) {
        try {
            J2EEManagedObject.removeObject(pServer, J2EEDomain.getDomainName() + ":" + "j2eeType" + "=" + "JMSResource" + "," + "name=" + pName + "," + "*");
        }
        catch (Exception e) {
            log.error((Object)"Could not destroy JSR-77 JMSResource Resource", (Throwable)e);
        }
    }

    public JMSResource(String resName, ObjectName j2eeServerName, ObjectName jmsServiceName) throws MalformedObjectNameException, InvalidParentException {
        super("JMSResource", resName, j2eeServerName);
        this.jmsServiceName = jmsServiceName;
        this.stats = new JMSStatsImpl(null);
    }

    public Stats getstats() {
        try {
            Map clients = (Map)this.server.getAttribute(this.jmsServiceName, "Clients");
            Iterator iterator = clients.keySet().iterator();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to obtain stats", (Throwable)e);
        }
        return this.stats;
    }

    public void resetStats() {
        this.stats.reset();
    }

    public String toString() {
        return "JMSResource { " + super.toString() + " } [ " + " ]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

