/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue.linear.codabar;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.BlankModule;
import net.sourceforge.barbecue.Module;
import net.sourceforge.barbecue.SeparatorModule;
import net.sourceforge.barbecue.linear.codabar.ModuleFactory;

public class CodabarBarcode
extends Barcode {
    public static final String DEFAULT_START = "A";
    public static final String DEFAULT_STOP = "C";
    private int width = 0;
    private String label;

    public CodabarBarcode(String string) throws BarcodeException {
        super(string);
        this.label = string;
        this.validateData();
    }

    protected String getLabel() {
        return this.label;
    }

    protected double getBarcodeWidth(int n) {
        this.encodeData();
        return this.barWidth * (double)this.width;
    }

    protected Module[] encodeData() {
        this.width = 0;
        ArrayList<Module> arrayList = new ArrayList<Module>();
        for (int j = 0; j < this.data.length(); ++j) {
            if (j > 0) {
                arrayList.add(new SeparatorModule(1));
                ++this.width;
            }
            char c2 = this.data.charAt(j);
            Module module = ModuleFactory.getModule(String.valueOf(c2));
            arrayList.add(module);
            this.width += module.widthInBars();
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        return null;
    }

    protected Module getPreAmble() {
        return new BlankModule(0);
    }

    protected Module getPostAmble() {
        return new BlankModule(0);
    }

    private void validateData() throws BarcodeException {
        this.replaceTraditionalStartStopWithModern();
        this.addDefaultStartStopIfRequired();
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.data);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (!Character.isWhitespace(c2)) {
                if (!ModuleFactory.isValid(String.valueOf(c2))) {
                    throw new BarcodeException(c2 + " is not a valid character for Codabar encoding");
                }
                this.checkStartStop(c2, n);
                stringBuffer.append(c2);
            }
            ++n;
            c2 = stringCharacterIterator.next();
        }
        this.data = stringBuffer.toString();
    }

    private void addDefaultStartStopIfRequired() {
        StringBuffer stringBuffer = new StringBuffer();
        if (!Character.isLetter(this.data.charAt(0))) {
            stringBuffer.append(DEFAULT_START);
        }
        stringBuffer.append(this.data);
        if (!Character.isLetter(this.data.charAt(this.data.length() - 1))) {
            stringBuffer.append(DEFAULT_STOP);
        }
        this.data = stringBuffer.toString();
    }

    private void replaceTraditionalStartStopWithModern() {
        this.data = this.data.replace('a', 'A');
        this.data = this.data.replace('t', 'A');
        this.data = this.data.replace('b', 'B');
        this.data = this.data.replace('n', 'B');
        this.data = this.data.replace('c', 'C');
        this.data = this.data.replace('*', 'C');
        this.data = this.data.replace('d', 'D');
        this.data = this.data.replace('e', 'D');
    }

    private void checkStartStop(char c2, int n) throws BarcodeException {
        if (Character.isLetter(c2) && n > 0 && n < this.data.length() - 1) {
            throw new BarcodeException(c2 + " is only allowed as the first and last characters for Codabar barcodes");
        }
    }
}

