/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core;

import com.edb.core.Logger;
import com.edb.core.ProtocolConnection;
import com.edb.core.v3.ConnectionFactoryImpl;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import java.sql.SQLException;
import java.util.Properties;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"3", new ConnectionFactoryImpl()}, {"2", new com.edb.core.v2.ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(String host, int port, String user, String database, Properties info, Logger logger) throws SQLException {
        String protoName = info.getProperty("protocolVersion");
        for (int i = 0; i < versions.length; ++i) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)versions[i][0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)versions[i][1]).openConnectionImpl(host, port, user, database, info, logger)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("No connection was able to be made for requested protocol {0}.", protoName));
    }

    public abstract ProtocolConnection openConnectionImpl(String var1, int var2, String var3, String var4, Properties var5, Logger var6) throws SQLException;
}

