/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Cash;
import org.compiere.acct.Fact;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Cash
extends Doc {
    public Doc_Cash(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MCash.class, rs, "CMC", trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MCash cash = (MCash)this.getPO();
        this.setDateDoc(cash.getStatementDate());
        this.setAmount(0, cash.getStatementDifference());
        MCashBook cb = MCashBook.get(this.getCtx(), cash.getC_CashBook_ID());
        this.setC_CashBook_ID(cb.getC_CashBook_ID());
        this.setC_Currency_ID(cb.getC_Currency_ID());
        this.p_lines = this.loadLines(cash, cb);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MCash cash, MCashBook cb) {
        ArrayList<DocLine_Cash> list = new ArrayList<DocLine_Cash>();
        MCashLine[] lines = cash.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MCashLine line = lines[i];
            DocLine_Cash docLine = new DocLine_Cash(line, this);
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        for (int i = 0; i < this.p_lines.length; ++i) {
            retValue = retValue.subtract(this.p_lines[i].getAmtSource());
            sb.append("-").append(this.p_lines[i].getAmtSource());
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        if (this.getC_CashBook_ID() == 0) {
            this.p_Error = "C_CashBook_ID not set";
            this.log.log(Level.SEVERE, this.p_Error);
            return null;
        }
        Fact fact = new Fact(this, as, "A");
        BigDecimal assetAmt = Env.ZERO;
        for (int i = 0; i < this.p_lines.length; ++i) {
            DocLine_Cash line = (DocLine_Cash)this.p_lines[i];
            String CashType = line.getCashType();
            if (CashType.equals("E")) {
                fact.createLine((DocLine)line, this.getAccount(22, as), this.getC_Currency_ID(), line.getAmount().negate(), null);
                assetAmt = assetAmt.subtract(line.getAmount().negate());
                continue;
            }
            if (CashType.equals("R")) {
                assetAmt = assetAmt.add(line.getAmount());
                fact.createLine((DocLine)line, this.getAccount(23, as), this.getC_Currency_ID(), null, line.getAmount());
                continue;
            }
            if (CashType.equals("C")) {
                fact.createLine((DocLine)line, line.getChargeAccount(as, this.getAmount()), this.getC_Currency_ID(), line.getAmount().negate(), null);
                assetAmt = assetAmt.subtract(line.getAmount().negate());
                continue;
            }
            if (CashType.equals("D")) {
                fact.createLine(line, this.getAccount(24, as), this.getC_Currency_ID(), line.getAmount().negate());
                assetAmt = assetAmt.add(line.getAmount());
                continue;
            }
            if (CashType.equals("I")) {
                if (line.getC_Currency_ID() == this.getC_Currency_ID()) {
                    assetAmt = assetAmt.add(line.getAmount());
                } else {
                    fact.createLine(line, this.getAccount(20, as), line.getC_Currency_ID(), line.getAmount());
                }
                fact.createLine(line, this.getAccount(21, as), line.getC_Currency_ID(), line.getAmount().negate());
                continue;
            }
            if (!CashType.equals("T")) continue;
            int temp = this.getC_BankAccount_ID();
            this.setC_BankAccount_ID(line.getC_BankAccount_ID());
            fact.createLine(line, this.getAccount(11, as), line.getC_Currency_ID(), line.getAmount().negate());
            this.setC_BankAccount_ID(temp);
            if (line.getC_Currency_ID() == this.getC_Currency_ID()) {
                assetAmt = assetAmt.add(line.getAmount());
                continue;
            }
            fact.createLine(line, this.getAccount(20, as), line.getC_Currency_ID(), line.getAmount());
        }
        fact.createLine(null, this.getAccount(20, as), this.getC_Currency_ID(), assetAmt);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }
}

