/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBufferedStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

abstract class OracleInputStream
extends OracleBufferedStream {
    int columnIndex;
    Accessor accessor;
    OracleInputStream nextStream;
    boolean hasBeenOpen = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Oct_30_03:26:14_PDT_2007";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected OracleInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, oracleStatement.connection.getDefaultStreamChunkSize());
        this.closed = true;
        this.statement = oracleStatement;
        this.columnIndex = n2;
        this.accessor = accessor;
        this.nextStream = null;
        OracleInputStream oracleInputStream = this.statement.streamList;
        if (oracleInputStream == null || this.columnIndex < oracleInputStream.columnIndex) {
            this.nextStream = this.statement.streamList;
            this.statement.streamList = this;
        } else if (this.columnIndex == oracleInputStream.columnIndex) {
            this.nextStream = oracleInputStream.nextStream;
            oracleInputStream.nextStream = null;
            this.statement.streamList = this;
        } else {
            while (oracleInputStream.nextStream != null && this.columnIndex > oracleInputStream.nextStream.columnIndex) {
                oracleInputStream = oracleInputStream.nextStream;
            }
            if (oracleInputStream.nextStream != null && this.columnIndex == oracleInputStream.nextStream.columnIndex) {
                this.nextStream = oracleInputStream.nextStream.nextStream;
                oracleInputStream.nextStream.nextStream = null;
                oracleInputStream.nextStream = this;
            } else {
                this.nextStream = oracleInputStream.nextStream;
                oracleInputStream.nextStream = this;
            }
        }
    }

    public String toString() {
        return "OIS@" + Integer.toHexString(this.hashCode()) + "{" + "statement = " + this.statement + ", accessor = " + this.accessor + ", nextStream = " + this.nextStream + ", columnIndex = " + this.columnIndex + ", hasBeenOpen = " + this.hasBeenOpen + "}";
    }

    public boolean needBytes() throws IOException {
        if (this.closed) {
            return false;
        }
        if (this.pos >= this.count) {
            try {
                int n2 = this.getBytes();
                this.pos = 0;
                this.count = n2;
                if (this.count == -1) {
                    if (this.nextStream == null) {
                        this.statement.connection.releaseLine();
                    }
                    this.closed = true;
                    this.accessor.fetchNextColumns();
                    return false;
                }
            }
            catch (SQLException sQLException) {
                DatabaseError.SQLToIOException(sQLException);
            }
        }
        return true;
    }

    public boolean isNull() throws IOException {
        boolean bl = false;
        try {
            bl = this.accessor.isNull(0);
        }
        catch (SQLException sQLException) {
            DatabaseError.SQLToIOException(sQLException);
        }
        return bl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            if (!this.closed && this.hasBeenOpen) {
                while (this.statement.nextStream != this) {
                    this.statement.nextStream.close();
                    this.statement.nextStream = this.statement.nextStream.nextStream;
                }
                if (!this.isNull()) {
                    while (this.needBytes()) {
                        this.pos = this.count;
                    }
                }
                this.closed = true;
            }
        }
    }

    public abstract int getBytes() throws IOException;
}

