/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.compiere.vos.WindowVO;

public class Response
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ArrayList messages = new ArrayList(1);
    protected boolean hasError = false;
    protected boolean hasWarning = false;
    protected HashMap params = null;
    public String[] commands = null;
    public int targetWinCmd = -1;
    public static int RELOAD = 1;
    public WindowVO newWindowVO = null;

    protected void addParam(String var, String v) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        this.params.put(var, v);
    }

    public String getParam(String var) {
        if (this.params == null) {
            return null;
        }
        return (String)this.params.get(var);
    }

    public int getProcessID() {
        if (this.getParam("START_PROCESS_ID") == null) {
            return -1;
        }
        return Integer.parseInt(this.getParam("START_PROCESS_ID"));
    }

    public void setProcessID(int processID) {
        this.addParam("START_PROCESS_ID", Integer.toString(processID));
    }

    private void addMessage(int type, String message) {
        if (type == 1) {
            this.hasError = true;
        }
        if (type == 2) {
            this.hasWarning = true;
        }
        this.messages.add(new Message(type, message));
    }

    public void addError(String message) {
        this.addMessage(1, message);
    }

    public void addWarning(String message) {
        this.addMessage(2, message);
    }

    public void addSuccess(String message) {
        this.addMessage(0, message);
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    public boolean hasError() {
        return this.hasError;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.messages.size(); ++i) {
            Message m = (Message)this.messages.get(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append(m.toString());
        }
        return sb.toString();
    }

    public String toDisplay() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.messages.size(); ++i) {
            Message m = (Message)this.messages.get(i);
            if (i > 0) {
                sb.append("<br>");
            }
            sb.append(m.toDisplay());
        }
        return sb.toString();
    }

    public void setParams(HashMap params) {
        this.params = params;
    }

    public static class Message
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int type;
        private String message;
        public static final int SUCCESS = 0;
        public static final int ERROR = 1;
        public static final int WARNING = 2;

        public Message() {
        }

        public Message(int type, String message) {
            this.type = type;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            if (this.type == 0) {
                return "Success: " + this.message;
            }
            if (this.type == 1) {
                return "Error: " + this.message;
            }
            if (this.type == 2) {
                return "Warning: " + this.message;
            }
            return "NO MESSAGE";
        }

        public String toDisplay() {
            return this.message;
        }
    }
}

