/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.test;

import java.math.BigDecimal;
import java.util.Random;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Login;
import org.compiere.util.Trx;

public class OrderTest
implements Runnable {
    int m_no = 0;
    int m_numberOrders = 0;
    int m_maxLines = 20;
    int m_errors = 0;
    private static CLogger log = CLogger.getCLogger(OrderTest.class);

    public OrderTest(int no, int numberOrders, int avgLines) {
        this.m_no = no;
        this.m_numberOrders = numberOrders;
        this.m_maxLines = avgLines * 2;
    }

    public void run() {
        long time = System.currentTimeMillis();
        int count = 0;
        MBPartner bp = new MBPartner(Env.getCtx(), 117, null);
        bp.setSOCreditStatus("X");
        bp.save();
        for (int i = 0; i < this.m_numberOrders; ++i) {
            Trx trx = Trx.get((String)Trx.createTrxName((String)("Test" + this.m_no + "_" + i)), (boolean)true);
            trx.start();
            MOrder order = new MOrder(Env.getCtx(), 0, trx.getTrxName());
            order.setDescription("#" + this.m_no + "_" + i);
            order.setC_DocTypeTarget_ID(135);
            order.setC_BPartner_ID(117);
            order.setSalesRep_ID(101);
            order.setDeliveryRule("F");
            if (!order.save()) {
                log.warning("#" + this.m_no + "_" + i + ": Not saved(1)");
                ++this.m_errors;
                continue;
            }
            Random r = new Random();
            int linesNumber = r.nextInt(this.m_maxLines) + 1;
            for (int j = 0; j < linesNumber; ++j) {
                MOrderLine line = new MOrderLine(order);
                line.setM_Product_ID(123);
                line.setQty(new BigDecimal(5));
                if (line.save()) continue;
                log.warning("#" + this.m_no + "_" + i + ": Line not saved");
                ++this.m_errors;
            }
            order.setDocAction("CO");
            if (!order.processIt("CO")) {
                log.warning("#" + this.m_no + "_" + i + ": Not processed");
                ++this.m_errors;
                trx.rollback();
                trx.close();
                continue;
            }
            if (!order.save()) {
                log.warning("#" + this.m_no + "_" + i + ": Not saved(2)");
                ++this.m_errors;
            } else {
                ++count;
            }
            trx.commit();
            trx.close();
            log.info(order.toString());
        }
        time = System.currentTimeMillis() - time;
        log.warning("#" + this.m_no + ", Errors=" + this.m_errors + ", Count=" + count + " " + (float)count * 100.0f / (float)this.m_numberOrders + "% - " + time + "ms - ea " + (float)time / (float)count + "ms");
    }

    public static void main(String[] args) {
        int i;
        Compiere.startup((boolean)true);
        CLogMgt.setLoggerLevel((Level)Level.INFO, null);
        CLogMgt.setLevel((Level)Level.INFO);
        Ini.setProperty((String)"ApplicationUserID", (String)"SuperUser");
        Ini.setProperty((String)"ApplicationPassword", (String)"System");
        Ini.setProperty((String)"Role", (String)"GardenWorld Admin");
        Ini.setProperty((String)"Client", (String)"GardenWorld");
        Ini.setProperty((String)"Organization", (String)"HQ");
        Ini.setProperty((String)"Warehouse", (String)"HQ Warehouse");
        Ini.setProperty((String)"Language", (String)"English");
        Login login = new Login(Env.getCtx());
        if (!login.batchLogin(null, null)) {
            System.exit(1);
        }
        CLogMgt.setLoggerLevel((Level)Level.WARNING, null);
        CLogMgt.setLevel((Level)Level.WARNING);
        int NO_TESTS = 2;
        int NO_ORDERS = 200;
        int NO_LINES = 20;
        long time = System.currentTimeMillis();
        Thread[] tests = new Thread[NO_TESTS];
        for (i = 0; i < tests.length; ++i) {
            tests[i] = new Thread(new OrderTest(i, NO_ORDERS, NO_LINES));
            tests[i].start();
        }
        for (i = 0; i < tests.length; ++i) {
            try {
                tests[i].join();
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        time = System.currentTimeMillis() - time;
        System.out.println("Time (ms)=" + time);
    }
}

