/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHMethodDeclaration;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.This;
import bsh.UtilEvalError;
import java.io.Serializable;

public class BshMethod
implements Serializable {
    NameSpace declaringNameSpace;
    Modifiers modifiers;
    private String name;
    private Object returnType;
    private String[] argNames;
    private int numArgs;
    private Class[] argTypes;
    private BSHBlock methodBody;

    BshMethod(BSHMethodDeclaration bSHMethodDeclaration, NameSpace nameSpace, Modifiers modifiers) {
        this.declaringNameSpace = nameSpace;
        this.modifiers = modifiers;
        this.name = bSHMethodDeclaration.name;
        this.returnType = bSHMethodDeclaration.returnType;
        this.argNames = bSHMethodDeclaration.params.argNames;
        this.numArgs = bSHMethodDeclaration.params.numArgs;
        this.argTypes = bSHMethodDeclaration.params.argTypes;
        this.methodBody = bSHMethodDeclaration.block;
    }

    BshMethod(String string, Object object2, String[] stringArray, Class[] classArray, BSHBlock bSHBlock, NameSpace nameSpace, Modifiers modifiers) {
        this.name = string;
        this.returnType = object2;
        this.argNames = stringArray;
        this.numArgs = stringArray.length;
        this.argTypes = classArray;
        this.methodBody = bSHBlock;
        this.declaringNameSpace = nameSpace;
        this.modifiers = modifiers;
    }

    public Class[] getArgumentTypes() {
        return this.argTypes;
    }

    public Object getReturnType() {
        return this.returnType;
    }

    Modifiers getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter) throws EvalError {
        return this.invoke(objectArray, interpreter, null, null, false);
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack) throws EvalError {
        return this.invoke(objectArray, interpreter, callStack, null, false);
    }

    public Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode) throws EvalError {
        return this.invoke(objectArray, interpreter, callStack, simpleNode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode, boolean bl) throws EvalError {
        if (this.modifiers != null && this.modifiers.hasModifier("synchronized")) {
            This this_;
            This this_2 = this_ = this.declaringNameSpace.getThis(interpreter);
            synchronized (this_2) {
                return this.invokeImpl(objectArray, interpreter, callStack, simpleNode, bl);
            }
        }
        return this.invokeImpl(objectArray, interpreter, callStack, simpleNode, bl);
    }

    private Object invokeImpl(Object[] objectArray, Interpreter interpreter, CallStack callStack, SimpleNode simpleNode, boolean bl) throws EvalError {
        NameSpace nameSpace;
        if (callStack == null) {
            callStack = new CallStack(this.declaringNameSpace);
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (objectArray.length != this.numArgs) {
            throw new EvalError("Wrong number of arguments for local method: " + this.name, simpleNode, callStack);
        }
        if (bl) {
            nameSpace = callStack.top();
        } else {
            nameSpace = new NameSpace(this.declaringNameSpace, this.name);
            nameSpace.isMethod = true;
        }
        nameSpace.setNode(simpleNode);
        int n = 0;
        while (n < this.numArgs) {
            if (this.argTypes[n] != null) {
                try {
                    objectArray[n] = NameSpace.getAssignableForm(objectArray[n], this.argTypes[n]);
                }
                catch (UtilEvalError utilEvalError) {
                    throw new EvalError("Invalid argument: `" + this.argNames[n] + "'" + " for method: " + this.name + " : " + utilEvalError.getMessage(), simpleNode, callStack);
                }
                try {
                    nameSpace.setTypedVariable(this.argNames[n], this.argTypes[n], objectArray[n], null);
                }
                catch (UtilEvalError utilEvalError) {
                    throw utilEvalError.toEvalError("Typed method parameter assignment", simpleNode, callStack);
                }
            }
            if (objectArray[n] == Primitive.VOID) {
                throw new EvalError("Undefined variable or class name, parameter: " + this.argNames[n] + " to method: " + this.name, simpleNode, callStack);
            }
            try {
                nameSpace.setLocalVariable(this.argNames[n], objectArray[n], interpreter.getStrictJava());
            }
            catch (UtilEvalError utilEvalError) {
                throw utilEvalError.toEvalError(simpleNode, callStack);
            }
            ++n;
        }
        if (!bl) {
            callStack.push(nameSpace);
        }
        Object object2 = this.methodBody.eval(callStack, interpreter, true);
        CallStack callStack2 = callStack.copy();
        if (!bl) {
            callStack.pop();
        }
        ReturnControl returnControl = null;
        if (object2 instanceof ReturnControl) {
            returnControl = (ReturnControl)object2;
            if (returnControl.kind != 46) {
                throw new EvalError("continue or break in method body", returnControl.returnPoint, callStack2);
            }
            object2 = ((ReturnControl)object2).value;
            if (this.returnType == Primitive.VOID && object2 != Primitive.VOID) {
                throw new EvalError("Cannot return value from void method", returnControl.returnPoint, callStack2);
            }
        }
        if (this.returnType != null) {
            if (this.returnType == Primitive.VOID) {
                return Primitive.VOID;
            }
            try {
                object2 = NameSpace.getAssignableForm(object2, (Class)this.returnType);
            }
            catch (UtilEvalError utilEvalError) {
                SimpleNode simpleNode2 = simpleNode;
                if (returnControl != null) {
                    simpleNode2 = returnControl.returnPoint;
                }
                throw utilEvalError.toEvalError("Incorrect type returned from method: " + this.name + utilEvalError.getMessage(), simpleNode2, callStack);
            }
        }
        return object2;
    }

    public boolean hasModifier(String string) {
        return this.modifiers != null && this.modifiers.hasModifier(string);
    }

    public String toString() {
        return "Scripted Method: " + StringUtil.methodString(this.name, this.getArgumentTypes());
    }
}

