/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.dev;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSSF {
    private String filename = null;
    private InputStream stream = null;
    private Record[] records = null;
    protected HSSFWorkbook hssfworkbook = null;

    public HSSF(String filename) throws IOException {
        this.filename = filename;
        POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(filename));
        this.hssfworkbook = new HSSFWorkbook(fs);
    }

    public HSSF(String filename, boolean write) throws IOException {
        short cellnum;
        int rownum = 0;
        FileOutputStream out = new FileOutputStream(filename);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet s2 = wb.createSheet();
        HSSFRow r = null;
        HSSFCell c2 = null;
        HSSFCellStyle cs = wb.createCellStyle();
        HSSFCellStyle cs2 = wb.createCellStyle();
        HSSFCellStyle cs3 = wb.createCellStyle();
        HSSFFont f2 = wb.createFont();
        HSSFFont f22 = wb.createFont();
        f2.setFontHeightInPoints((short)12);
        f2.setColor((short)10);
        f2.setBoldweight((short)700);
        f22.setFontHeightInPoints((short)10);
        f22.setColor((short)15);
        f22.setBoldweight((short)700);
        cs.setFont(f2);
        cs.setDataFormat(HSSFDataFormat.getBuiltinFormat("($#,##0_);[Red]($#,##0)"));
        cs2.setBorderBottom((short)1);
        cs2.setFillPattern((short)1);
        cs2.setFillForegroundColor((short)10);
        cs2.setFont(f22);
        wb.setSheetName(0, "HSSF Test");
        for (rownum = 0; rownum < 300; rownum = (int)((short)(rownum + 1))) {
            r = s2.createRow(rownum);
            if (rownum % 2 == 0) {
                r.setHeight((short)585);
            }
            for (cellnum = 0; cellnum < 50; cellnum = (short)(cellnum + 2)) {
                c2 = r.createCell(cellnum, 0);
                c2.setCellValue((double)(rownum * 10000 + cellnum) + ((double)rownum / 1000.0 + (double)cellnum / 10000.0));
                if (rownum % 2 == 0) {
                    c2.setCellStyle(cs);
                }
                c2 = r.createCell((short)(cellnum + 1), 1);
                c2.setCellValue("TEST");
                s2.setColumnWidth((short)(cellnum + 1), (short)8000);
                if (rownum % 2 != 0) continue;
                c2.setCellStyle(cs2);
            }
        }
        rownum = (short)(rownum + 1);
        rownum = (short)(rownum + 1);
        r = s2.createRow(rownum);
        cs3.setBorderBottom((short)5);
        for (cellnum = 0; cellnum < 50; cellnum = (short)(cellnum + 1)) {
            c2 = r.createCell(cellnum, 3);
            c2.setCellStyle(cs3);
        }
        s2.addMergedRegion(new Region(0, 0, 3, 3));
        s2.addMergedRegion(new Region(100, 100, 110, 110));
        s2 = wb.createSheet();
        wb.setSheetName(1, "DeletedSheet");
        wb.removeSheetAt(1);
        wb.write(out);
        out.close();
    }

    public HSSF(String infile, String outfile, boolean write) throws IOException {
        this.filename = this.filename;
        POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(this.filename));
        this.hssfworkbook = new HSSFWorkbook(fs);
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            if (args.length == 2) {
                if (args[1].toLowerCase().equals("write")) {
                    System.out.println("Write mode");
                    try {
                        long time = System.currentTimeMillis();
                        HSSF hssf = new HSSF(args[0], true);
                        System.out.println("" + (System.currentTimeMillis() - time) + " ms generation time");
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                } else {
                    System.out.println("readwrite test");
                    try {
                        HSSF hssf = new HSSF(args[0]);
                        HSSFWorkbook wb = hssf.hssfworkbook;
                        FileOutputStream stream = new FileOutputStream(args[1]);
                        wb.write(stream);
                        stream.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            } else if (args.length == 3 && args[2].toLowerCase().equals("modify1")) {
                try {
                    HSSFRow row;
                    int k;
                    HSSF hssf = new HSSF(args[0]);
                    HSSFWorkbook wb = hssf.hssfworkbook;
                    FileOutputStream stream = new FileOutputStream(args[1]);
                    HSSFSheet sheet = wb.getSheetAt(0);
                    for (k = 0; k < 25; ++k) {
                        row = sheet.getRow(k);
                        sheet.removeRow(row);
                    }
                    for (k = 74; k < 100; ++k) {
                        row = sheet.getRow(k);
                        sheet.removeRow(row);
                    }
                    HSSFRow row2 = sheet.getRow(39);
                    HSSFCell cell = row2.getCell((short)3);
                    cell.setCellType(1);
                    cell.setCellValue("MODIFIED CELL!!!!!");
                    wb.write(stream);
                    stream.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
    }
}

