/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.util.CLogger;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.wstore.WebBasket;

public class CheckOutServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "checkOutServlet";
    public static final String ATTR_CHECKOUT = "CheckOut";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("CheckOutServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web CheckOut Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        WebUser wu = (WebUser)session.getAttribute("webUser");
        WebBasket wb = (WebBasket)session.getAttribute("webBasket");
        String url = "/login.jsp";
        if (wb == null || wb.getLineCount() == 0) {
            url = "/basket.jsp";
        } else {
            session.setAttribute(ATTR_CHECKOUT, (Object)"Y");
            if (wu != null && wu.isLoggedIn()) {
                url = "/addressInfo.jsp";
            }
        }
        this.log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(false);
    }
}

