/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MInvoice;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class InvoiceServlet
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(InvoiceServlet.class);
    public static final String NAME = "invoiceServlet";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("InvoiceServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Invoice Servlet";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        String url = "/invoices.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            String msg;
            session.removeAttribute("hdrMessage");
            WebInfo info = (WebInfo)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            if ((msg = this.streamInvoice(request, response)) == null || msg.length() == 0) {
                return;
            }
            if (info != null) {
                info.setMessage(msg);
            }
        }
        log.info("Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        this.doGet(request, response);
    }

    private String streamInvoice(HttpServletRequest request, HttpServletResponse response) {
        int MIN_SIZE = 2000;
        int C_Invoice_ID = WebUtil.getParameterAsInt(request, "Invoice_ID");
        if (C_Invoice_ID == 0) {
            log.fine("No ID)");
            return "No Invoice ID";
        }
        Ctx ctx = JSPEnv.getCtx(request);
        MInvoice invoice = new MInvoice(ctx, C_Invoice_ID, null);
        if (invoice.getC_Invoice_ID() != C_Invoice_ID) {
            log.fine("Invoice not found - ID=" + C_Invoice_ID);
            return "Invoice not found";
        }
        HttpSession session = request.getSession(true);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu.getC_BPartner_ID() != invoice.getC_BPartner_ID()) {
            log.warning("Invoice from BPartner - C_Invoice_ID=" + C_Invoice_ID + " - BP_Invoice=" + invoice.getC_BPartner_ID() + " = BP_Web=" + wu.getC_BPartner_ID());
            return "Your invoice not found";
        }
        String dirName = ctx.getContext("documentDir");
        if (dirName == null || dirName.length() == 0) {
            dirName = ".";
        }
        try {
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Could not create directory " + dirName, ex);
            return "Streaming error - directory";
        }
        String fileName = invoice.getPDFFileName(dirName);
        File file = new File(fileName);
        if (file.exists() && file.isFile() && file.length() > (long)MIN_SIZE) {
            log.info("Existing: " + file + " - " + new Timestamp(file.lastModified()));
        } else {
            log.info("New: " + fileName);
            file = invoice.createPDF(file);
            if (file != null) {
                invoice.setDatePrinted(new Timestamp(System.currentTimeMillis()));
                invoice.save();
            }
        }
        if (file == null || !file.exists() || file.length() < (long)MIN_SIZE) {
            log.warning("File does not exist - " + file);
            return "Streaming error - file";
        }
        try {
            int bufferSize = 2048;
            int fileLength = (int)file.length();
            response.setContentType("application/pdf");
            response.setBufferSize(bufferSize);
            response.setContentLength(fileLength);
            log.fine(file.getAbsolutePath() + ", length=" + fileLength);
            long time = System.currentTimeMillis();
            FileInputStream in = new FileInputStream(file);
            ServletOutputStream out = response.getOutputStream();
            byte[] buffer = new byte[bufferSize];
            double totalSize = 0.0;
            int count = 0;
            do {
                if ((count = in.read(buffer, 0, bufferSize)) <= 0) continue;
                totalSize += (double)count;
                out.write(buffer, 0, count);
            } while (count != -1);
            out.flush();
            out.close();
            in.close();
            time = System.currentTimeMillis() - time;
            double speed = totalSize / 1024.0 / ((double)time / 1000.0);
            log.fine("Length=" + totalSize + " - " + time + " ms - " + speed + " kB/sec");
        }
        catch (IOException ex) {
            log.log(Level.SEVERE, ex.toString());
            return "Streaming error";
        }
        return null;
    }
}

