/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAttachment;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.WebEnv;
import org.compiere.util.WebInfo;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wstore.JSPEnv;

public class WorkflowServlet
extends HttpServlet {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "WorkflowServlet";
    public static final String P_WF_Activity_ID = "AD_WF_Activity_ID";
    public static final String P_ATTACHMENT_INDEX = "AttachmentIndex";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WorkflowServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Workflow Servlet";
    }

    public void destroy() {
        this.log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet from " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - forward to notes.jsp");
        String url = "/notes.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            String msg;
            session.removeAttribute("hdrMessage");
            WebInfo info = (WebInfo)session.getAttribute("info");
            if (info != null) {
                info.setMessage("");
            }
            if ((msg = this.streamAttachment(request, response)) == null || msg.length() == 0) {
                return;
            }
            if (info != null) {
                info.setMessage(msg);
            }
        }
        this.log.info("doGet - Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private String streamAttachment(HttpServletRequest request, HttpServletResponse response) {
        int AD_WF_Activity_ID = WebUtil.getParameterAsInt(request, P_WF_Activity_ID);
        if (AD_WF_Activity_ID == 0) {
            this.log.fine("streamAttachment - no AD_WF_Activity_ID)");
            return "No Activity ID";
        }
        int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
        if (attachmentIndex == 0) {
            this.log.fine("streamAttachment - no index)");
            return "No Request Attachment index";
        }
        this.log.info("streamAttachment - AD_WF_Activity_ID=" + AD_WF_Activity_ID + " / " + attachmentIndex);
        Ctx ctx = JSPEnv.getCtx(request);
        MWFActivity doc = new MWFActivity(ctx, AD_WF_Activity_ID, null);
        if (doc.get_ID() != AD_WF_Activity_ID) {
            this.log.fine("streamAttachment - Activity not found - ID=" + AD_WF_Activity_ID);
            return "Activity not found";
        }
        MAttachment attachment = doc.getAttachment(false);
        if (attachment == null) {
            this.log.fine("streamAttachment - No Attachment for AD_WF_Activity_ID=" + AD_WF_Activity_ID);
            return "Notice Attachment not found";
        }
        HttpSession session = request.getSession(true);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu.getAD_User_ID() != doc.getAD_User_ID()) {
            this.log.warning("streamAttachment - AD_WF_Activity_ID=" + AD_WF_Activity_ID + " - User_Activity=" + doc.getAD_User_ID() + " = Web_User=" + wu.getAD_User_ID());
            return "Your Activity not found";
        }
        return WebUtil.streamAttachment(response, attachment, attachmentIndex);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        String url = "/notes.jsp";
        HttpSession session = request.getSession(false);
        if (session == null || session.getAttribute("info") == null) {
            url = "/login.jsp";
        } else {
            session.removeAttribute("hdrMessage");
            Ctx ctx = JSPEnv.getCtx(request);
            WebUser wu = (WebUser)session.getAttribute("webUser");
            if (wu == null) {
                this.log.warning("doPost - no web user");
                if (!response.isCommitted()) {
                    response.sendRedirect("loginServlet?ForwardTo=note.jsp");
                }
                return;
            }
            int AD_WF_Activity_ID = WebUtil.getParameterAsInt(request, P_WF_Activity_ID);
            boolean isConfirmed = WebUtil.getParameterAsBoolean(request, "IsConfirmed");
            boolean isApproved = WebUtil.getParameterAsBoolean(request, "IsApproved");
            boolean isRejected = WebUtil.getParameterAsBoolean(request, "IsApproved");
            String textMsg = WebUtil.getParameter(request, "textMsg");
            this.log.fine("doPost - TextMsg=" + textMsg);
            MWFActivity act = new MWFActivity(ctx, AD_WF_Activity_ID, null);
            this.log.fine("doPost - " + act);
            if (AD_WF_Activity_ID == 0 || act == null || act.getAD_WF_Activity_ID() != AD_WF_Activity_ID) {
                session.setAttribute("hdrMessage", (Object)"Activity not found");
            } else if (act.isUserApproval() && (isApproved || isRejected)) {
                try {
                    act.setUserChoice(wu.getAD_User_ID(), isApproved ? "Y" : "N", 20, textMsg);
                    act.save();
                }
                catch (Exception e) {}
            } else if (act.isUserManual() && isConfirmed) {
                act.setUserConfirmation(wu.getAD_User_ID(), textMsg);
                act.save();
            } else if (textMsg != null && textMsg.length() > 0) {
                act.setTextMsg(textMsg);
                act.save();
            }
        }
        this.log.info("doGet - Forward to " + url);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(url);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }
}

