/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceConfig;
import org.jboss.services.binding.ServicesConfigDelegate;
import org.w3c.dom.Element;

public class XSLTFileDelegate
implements ServicesConfigDelegate {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$services$binding$XSLTFileDelegate == null ? (class$org$jboss$services$binding$XSLTFileDelegate = XSLTFileDelegate.class$("org.jboss.services.binding.XSLTFileDelegate")) : class$org$jboss$services$binding$XSLTFileDelegate));
    static /* synthetic */ Class class$org$jboss$services$binding$XSLTFileDelegate;

    public void applyConfig(ServiceConfig config, MBeanServer server) throws Exception {
        Element delegateConfig = (Element)config.getServiceConfigDelegateConfig();
        if (delegateConfig == null) {
            throw new IllegalArgumentException("ServiceConfig.ServiceConfigDelegateConfig is null");
        }
        Element xslConfigElement = (Element)delegateConfig.getElementsByTagName("xslt-config").item(0);
        if (xslConfigElement == null) {
            throw new IllegalArgumentException("No valid xslt config found");
        }
        String configName = xslConfigElement.getAttribute("configName");
        log.debug((Object)("configName = " + configName));
        if (configName.length() == 0) {
            throw new IllegalArgumentException("No valid configName attribute found");
        }
        ObjectName serviceName = new ObjectName(config.getServiceName());
        log.debug((Object)("serviceName = " + serviceName));
        String oldValue = (String)server.getAttribute(serviceName, configName);
        log.debug((Object)("oldValue = " + oldValue));
        String tmpName = System.getProperty("jboss.server.temp.dir");
        File tempDirectory = new File(tmpName);
        File targetFile = File.createTempFile("server", ".xml", tempDirectory);
        targetFile.deleteOnExit();
        log.debug((Object)("targetFile: " + targetFile.getCanonicalPath()));
        ServiceBinding[] bindings = config.getBindings();
        if (bindings == null || bindings.length == 0) {
            throw new IllegalArgumentException("No port binding specified");
        }
        int port = bindings[0].getPort();
        String host = bindings[0].getHostName();
        try {
            String xslText = xslConfigElement.getFirstChild().getNodeValue();
            log.trace((Object)("XSL text:" + xslText));
            StreamSource xslSource = new StreamSource(new StringReader(xslText));
            StreamSource xmlSource = new StreamSource(this.getClass().getClassLoader().getResourceAsStream(oldValue));
            StreamResult xmlResult = new StreamResult(new FileOutputStream(targetFile));
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xslSource);
            transformer.setParameter("port", new Integer(port));
            if (host != null) {
                transformer.setParameter("host", host);
            }
            transformer.transform(xmlSource, xmlResult);
            Attribute mbeanConfigAttr = new Attribute(configName, targetFile.getCanonicalPath());
            server.setAttribute(serviceName, mbeanConfigAttr);
        }
        catch (Exception ex) {
            log.error((Object)"Error while transforming xml", (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

