/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.filter;

import java.text.StringCharacterIterator;
import java.util.Hashtable;
import org.apache.ecs.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterFilter
extends Hashtable<String, Object>
implements Filter {
    public CharacterFilter() {
        super(4);
        this.addAttribute("\"", "&#34;");
        this.addAttribute("'", "&#8217;");
        this.addAttribute("&", "&#38;");
        this.addAttribute("<", "&#60;");
        this.addAttribute(">", "&#62;");
    }

    @Override
    public String getInfo() {
        return "CharacterFilter";
    }

    @Override
    public Filter addAttribute(String name, Object attribute) {
        this.put(name, attribute);
        return this;
    }

    @Override
    public Filter removeAttribute(String name) {
        try {
            this.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.containsKey(key);
    }

    @Override
    public String process(String to_process) {
        if (to_process == null || to_process.length() == 0) {
            return "";
        }
        StringBuffer bs = new StringBuffer(to_process.length() + 50);
        StringCharacterIterator sci = new StringCharacterIterator(to_process);
        String tmp = null;
        char c2 = sci.first();
        while (c2 != '\uffff') {
            char ii;
            tmp = String.valueOf(c2);
            if (this.hasAttribute(tmp)) {
                tmp = (String)this.get(tmp);
            }
            if ((ii = c2) > '\u00ff') {
                tmp = "&#" + ii + ";";
            }
            bs.append(tmp);
            c2 = sci.next();
        }
        return bs.toString();
    }
}

