/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.controller;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.api.CalloutInterface;
import org.compiere.common.ChangeVO;
import org.compiere.controller.UIField;
import org.compiere.framework.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Env;

public class UICalloutEngine
implements CalloutInterface {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private String m_name = this.getClass().getName();

    public UICalloutEngine() {
        int index = this.m_name.lastIndexOf(".");
        if (index > 0) {
            this.m_name = this.m_name.substring(index + 1);
        }
        this.m_name = this.m_name + ": ";
    }

    public ChangeVO start(Ctx ctx, int windowNo, PO po, UIField field, String oldValue, String newValue, String methodName) {
        ChangeVO retValue = new ChangeVO();
        if (methodName == null || methodName.length() == 0) {
            retValue.addError(this.m_name + "No Method Name");
            return retValue;
        }
        Method method = this.getMethod(methodName);
        if (method == null) {
            retValue.addError(this.m_name + "Method not found: " + methodName);
            return retValue;
        }
        int argLength = method.getParameterTypes().length;
        if (argLength != 5) {
            retValue.addError(this.m_name + "Method " + methodName + " has invalid no of arguments: " + argLength);
            return retValue;
        }
        StringBuffer msg = new StringBuffer(methodName).append(" - ").append(field.getColumnName()).append("=").append(newValue).append(" (old=").append(oldValue).append(")");
        this.log.info(msg.toString());
        try {
            Object[] args = new Object[]{ctx, new Integer(windowNo), field, oldValue, newValue};
            retValue = (ChangeVO)method.invoke((Object)this, args);
        }
        catch (Exception e) {
            Throwable ex = e.getCause();
            if (ex == null) {
                ex = e;
            }
            this.log.log(Level.WARNING, methodName, ex);
            ex.printStackTrace(System.err);
            retValue.addError(ex.getLocalizedMessage());
        }
        return retValue;
    }

    private Method getMethod(String methodName) {
        Method[] allMethods = this.getClass().getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!methodName.equals(allMethods[i].getName())) continue;
            return allMethods[i];
        }
        return null;
    }

    public ChangeVO rate(Ctx ctx, int windowNo, UIField field, String oldValue, String newValue) {
        ChangeVO retValue = new ChangeVO();
        BigDecimal rate1 = field.convertToBigDecimal(newValue);
        if (rate1 == null) {
            rate1 = Env.ZERO;
        }
        BigDecimal rate2 = Env.ZERO;
        BigDecimal one = new BigDecimal(1.0);
        if (rate1.doubleValue() != 0.0) {
            rate2 = one.divide(rate1, 12, 4);
        }
        if (field.getColumnName().equals("MultiplyRate")) {
            retValue.addChangedValue("DivideRate", (Object)field.convertToString(rate2));
        } else {
            retValue.addChangedValue("MultiplyRate", (Object)field.convertToString(rate2));
        }
        this.log.info(field.getColumnName() + "=" + rate1 + " => " + rate2);
        return retValue;
    }

    public ChangeVO dateAcct(Ctx ctx, int windowNo, UIField field, String oldValue, String newValue) {
        if (newValue == null || newValue.length() == 0) {
            return null;
        }
        Timestamp value = field.convertToTimestamp(newValue);
        if (value == null) {
            return null;
        }
        ChangeVO retValue = new ChangeVO();
        retValue.addChangedValue("DateAcct", (Object)newValue);
        this.log.info("DateAcct=" + value);
        return retValue;
    }
}

