/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.api.AccountingInterface;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MTable;
import org.compiere.model.X_C_DocBaseType;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDocBaseType
extends X_C_DocBaseType {
    private static CLogger s_log = CLogger.getCLogger(MDocBaseType.class);
    private static MDocBaseType[] s_docBaseTypes = null;
    public static final String DOCBASETYPE_APCreditMemo = "APC";
    public static final String DOCBASETYPE_APInvoice = "API";
    public static final String DOCBASETYPE_APPayment = "APP";
    public static final String DOCBASETYPE_ARCreditMemo = "ARC";
    public static final String DOCBASETYPE_ARProFormaInvoice = "ARF";
    public static final String DOCBASETYPE_ARInvoice = "ARI";
    public static final String DOCBASETYPE_ARReceipt = "ARR";
    public static final String DOCBASETYPE_PaymentAllocation = "CMA";
    public static final String DOCBASETYPE_BankStatement = "CMB";
    public static final String DOCBASETYPE_CashJournal = "CMC";
    public static final String DOCBASETYPE_GLDocument = "GLD";
    public static final String DOCBASETYPE_GLJournal = "GLJ";
    public static final String DOCBASETYPE_MaterialPhysicalInventory = "MMI";
    public static final String DOCBASETYPE_MaterialMovement = "MMM";
    public static final String DOCBASETYPE_MaterialProduction = "MMP";
    public static final String DOCBASETYPE_MaterialReceipt = "MMR";
    public static final String DOCBASETYPE_MaterialDelivery = "MMS";
    public static final String DOCBASETYPE_MatchInvoice = "MXI";
    public static final String DOCBASETYPE_MatchPO = "MXP";
    public static final String DOCBASETYPE_ProjectIssue = "PJI";
    public static final String DOCBASETYPE_PurchaseOrder = "POO";
    public static final String DOCBASETYPE_PurchaseRequisition = "POR";
    public static final String DOCBASETYPE_SalesOrder = "SOO";

    public static MDocBaseType[] getAll(Ctx ctx) {
        if (s_docBaseTypes != null) {
            return s_docBaseTypes;
        }
        ArrayList<MDocBaseType> list = new ArrayList<MDocBaseType>();
        String sql = "SELECT * FROM C_DocbaseType WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MDocBaseType(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_docBaseTypes = new MDocBaseType[list.size()];
        list.toArray(s_docBaseTypes);
        return s_docBaseTypes;
    }

    public static MDocBaseType getForTable(Ctx ctx, int AD_Table_ID) {
        if (s_docBaseTypes == null) {
            MDocBaseType.getAll(ctx);
        }
        for (int i = 0; i < s_docBaseTypes.length; ++i) {
            MDocBaseType dbt = s_docBaseTypes[i];
            if (dbt.getAD_Table_ID() != AD_Table_ID) continue;
            return dbt;
        }
        return null;
    }

    public MDocBaseType(Ctx ctx, int C_DocBaseType_ID, String trxName) {
        super(ctx, C_DocBaseType_ID, trxName);
    }

    public MDocBaseType(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public void setDocBaseType(String DocBaseType) {
        if (DocBaseType != null) {
            super.setDocBaseType(DocBaseType.toUpperCase());
        }
    }

    public boolean checkDocBaseType() {
        String s = this.getDocBaseType();
        if (s == null || s.length() != 3) {
            return false;
        }
        if (!s.equals(s.toUpperCase())) {
            this.setDocBaseType(s.toUpperCase());
        }
        return true;
    }

    @Override
    public int getAD_Table_ID() {
        int AD_Table_ID = super.getAD_Table_ID();
        if (AD_Table_ID > 0) {
            return AD_Table_ID;
        }
        String dbt = this.getDocBaseType();
        if (dbt.equals(DOCBASETYPE_SalesOrder) || dbt.equals(DOCBASETYPE_PurchaseOrder)) {
            return 259;
        }
        if (dbt.equals(DOCBASETYPE_MaterialReceipt) || dbt.equals(DOCBASETYPE_MaterialDelivery)) {
            return 319;
        }
        if (dbt.equals(DOCBASETYPE_APInvoice) || dbt.equals(DOCBASETYPE_APCreditMemo) || dbt.equals(DOCBASETYPE_ARInvoice) || dbt.equals(DOCBASETYPE_ARCreditMemo) || dbt.equals(DOCBASETYPE_ARProFormaInvoice)) {
            return 318;
        }
        if (dbt.equals(DOCBASETYPE_APPayment) || dbt.equals(DOCBASETYPE_ARReceipt)) {
            return 335;
        }
        if (dbt.equals(DOCBASETYPE_PaymentAllocation)) {
            return 735;
        }
        if (dbt.equals(DOCBASETYPE_CashJournal)) {
            return 407;
        }
        if (dbt.equals(DOCBASETYPE_BankStatement)) {
            return 392;
        }
        if (dbt.equals(DOCBASETYPE_MaterialPhysicalInventory)) {
            return 321;
        }
        if (dbt.equals(DOCBASETYPE_MaterialMovement)) {
            return 323;
        }
        if (dbt.equals(DOCBASETYPE_MaterialProduction)) {
            return 325;
        }
        if (dbt.equals(DOCBASETYPE_GLJournal)) {
            return 224;
        }
        if (dbt.equals(DOCBASETYPE_GLDocument)) {
            return 0;
        }
        if (dbt.equals(DOCBASETYPE_MatchInvoice)) {
            return 472;
        }
        if (dbt.equals(DOCBASETYPE_MatchPO)) {
            return 473;
        }
        if (dbt.equals(DOCBASETYPE_ProjectIssue)) {
            return 623;
        }
        if (dbt.equals(DOCBASETYPE_PurchaseRequisition)) {
            return 702;
        }
        this.log.warning("No AD_Table_ID for " + this.getName() + " (DocBaseType=" + dbt + ")");
        return 0;
    }

    public String getTableName() {
        int AD_Table_ID = this.getAD_Table_ID();
        if (AD_Table_ID == 0) {
            return null;
        }
        if (AD_Table_ID == 259) {
            return "C_Order";
        }
        if (AD_Table_ID == 319) {
            return "M_InOut";
        }
        if (AD_Table_ID == 318) {
            return "C_Invoice";
        }
        if (AD_Table_ID == 335) {
            return "C_Payment";
        }
        if (AD_Table_ID == 735) {
            return "C_AllocationHdr";
        }
        if (AD_Table_ID == 407) {
            return "C_Cash";
        }
        if (AD_Table_ID == 392) {
            return "C_BankStatement";
        }
        if (AD_Table_ID == 321) {
            return "M_Inventory";
        }
        if (AD_Table_ID == 323) {
            return "M_Movement";
        }
        if (AD_Table_ID == 224) {
            return "GL_Journal";
        }
        if (AD_Table_ID == 472) {
            return "M_MatchInv";
        }
        if (AD_Table_ID == 473) {
            return "M_MatchPO";
        }
        if (AD_Table_ID == 623) {
            return "C_ProjectIssue";
        }
        if (AD_Table_ID == 702) {
            return "M_Requisition";
        }
        return MTable.getTableName(this.getCtx(), AD_Table_ID);
    }

    @Override
    public String getAccountingClassname() {
        String className = super.getAccountingClassname();
        if (className != null && className.length() > 0) {
            return className;
        }
        String dbt = this.getDocBaseType();
        if (dbt.equals(DOCBASETYPE_SalesOrder) || dbt.equals(DOCBASETYPE_PurchaseOrder)) {
            return "org.compiere.acct.Doc_Order";
        }
        if (dbt.equals(DOCBASETYPE_MaterialReceipt) || dbt.equals(DOCBASETYPE_MaterialDelivery)) {
            return "org.compiere.acct.Doc_InOut";
        }
        if (dbt.equals(DOCBASETYPE_APInvoice) || dbt.equals(DOCBASETYPE_APCreditMemo) || dbt.equals(DOCBASETYPE_ARInvoice) || dbt.equals(DOCBASETYPE_ARCreditMemo) || dbt.equals(DOCBASETYPE_ARProFormaInvoice)) {
            return "org.compiere.acct.Doc_Invoice";
        }
        if (dbt.equals(DOCBASETYPE_APPayment) || dbt.equals(DOCBASETYPE_ARReceipt)) {
            return "org.compiere.acct.Doc_Payment";
        }
        if (dbt.equals(DOCBASETYPE_PaymentAllocation)) {
            return "org.compiere.acct.Doc_Allocation";
        }
        if (dbt.equals(DOCBASETYPE_CashJournal)) {
            return "org.compiere.acct.Doc_Cash";
        }
        if (dbt.equals(DOCBASETYPE_BankStatement)) {
            return "org.compiere.acct.Doc_Bank";
        }
        if (dbt.equals(DOCBASETYPE_MaterialPhysicalInventory)) {
            return "org.compiere.acct.Doc_Inventory";
        }
        if (dbt.equals(DOCBASETYPE_MaterialMovement)) {
            return "org.compiere.acct.Doc_Movement";
        }
        if (dbt.equals(DOCBASETYPE_MaterialProduction)) {
            return "org.compiere.acct.Doc_Production";
        }
        if (dbt.equals(DOCBASETYPE_GLJournal)) {
            return "org.compiere.acct.Doc_GLJournal";
        }
        if (dbt.equals(DOCBASETYPE_GLDocument)) {
            return null;
        }
        if (dbt.equals(DOCBASETYPE_MatchInvoice)) {
            return "org.compiere.acct.Doc_MatchInv";
        }
        if (dbt.equals(DOCBASETYPE_MatchPO)) {
            return "org.compiere.acct.Doc_MatchPO";
        }
        if (dbt.equals(DOCBASETYPE_ProjectIssue)) {
            return "org.compiere.acct.Doc_ProjectIssue";
        }
        if (dbt.equals(DOCBASETYPE_PurchaseRequisition)) {
            return "org.compiere.acct.Doc_Requisition";
        }
        return null;
    }

    protected Class<?> getAccountingClass() {
        String className = this.getAccountingClassname();
        if (className == null || className.length() == 0) {
            this.log.warning("No ClassName defined");
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (Exception e) {
            this.log.warning("Error creating class for " + this.getName() + ": - " + e.toString());
            return null;
        }
    }

    public AccountingInterface getAccountingInstance(MAcctSchema[] ass, ResultSet rs, String trxName) {
        Class<?> clazz = this.getAccountingClass();
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<?> constr = clazz.getConstructor(MAcctSchema[].class, ResultSet.class, String.class);
            AccountingInterface retValue = (AccountingInterface)constr.newInstance(ass, rs, trxName);
            return retValue;
        }
        catch (Exception e) {
            this.log.warning("Error instanciating " + this.getName() + ": - " + e.toString());
            return null;
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Table_ID() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AD_Table_ID"));
            return false;
        }
        String s = this.getAccountingClassname();
        if (s == null || s.length() == 0) {
            this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "AccountingClassname"));
            return false;
        }
        return this.checkDocBaseType();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MDocBaseType[").append(this.getName()).append(",AD_Table_ID=").append(this.getAD_Table_ID()).append(", Class=").append(this.getAccountingClassname()).append("]");
        return sb.toString();
    }
}

