/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import org.compiere.model.MAccount;
import org.compiere.model.X_C_ElementValue;
import org.compiere.model.X_I_ElementValue;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MElementValue
extends X_C_ElementValue {
    public MElementValue(Ctx ctx, int C_ElementValue_ID, String trxName) {
        super(ctx, C_ElementValue_ID, trxName);
        if (C_ElementValue_ID == 0) {
            this.setIsSummary(false);
            this.setAccountSign("N");
            this.setAccountType("E");
            this.setIsDocControlled(false);
            this.setIsForeignCurrency(false);
            this.setIsBankAccount(false);
            this.setPostActual(true);
            this.setPostBudget(true);
            this.setPostEncumbrance(true);
            this.setPostStatistical(true);
        }
    }

    public MElementValue(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MElementValue(Ctx ctx, String Value, String Name2, String Description, String AccountType, String AccountSign, boolean IsDocControlled, boolean IsSummary, String trxName) {
        this(ctx, 0, trxName);
        this.setValue(Value);
        this.setName(Name2);
        this.setDescription(Description);
        this.setAccountType(AccountType);
        this.setAccountSign(AccountSign);
        this.setIsDocControlled(IsDocControlled);
        this.setIsSummary(IsSummary);
    }

    public MElementValue(X_I_ElementValue imp) {
        this(imp.getCtx(), 0, imp.get_TrxName());
        this.setClientOrg(imp);
        this.set(imp);
    }

    public void set(X_I_ElementValue imp) {
        this.setValue(imp.getValue());
        this.setName(imp.getName());
        this.setDescription(imp.getDescription());
        this.setAccountType(imp.getAccountType());
        this.setAccountSign(imp.getAccountSign());
        this.setIsSummary(imp.isSummary());
        this.setIsDocControlled(imp.isDocControlled());
        this.setC_Element_ID(imp.getC_Element_ID());
        this.setPostActual(imp.isPostActual());
        this.setPostBudget(imp.isPostBudget());
        this.setPostEncumbrance(imp.isPostEncumbrance());
        this.setPostStatistical(imp.isPostStatistical());
    }

    public boolean isBalanceSheet() {
        String accountType = this.getAccountType();
        return "A".equals(accountType) || "L".equals(accountType) || "O".equals(accountType);
    }

    public boolean isActiva() {
        return "A".equals(this.getAccountType());
    }

    public boolean isPassiva() {
        String accountType = this.getAccountType();
        return "L".equals(accountType) || "O".equals(accountType);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getValue()).append(" - ").append(this.getName());
        return sb.toString();
    }

    public String toStringX() {
        StringBuffer sb = new StringBuffer("MElementValue[");
        sb.append(this.get_ID()).append(",").append(this.getValue()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (!newRecord && this.isSummary() && this.is_ValueChanged("IsSummary")) {
            String sql = "SELECT COUNT(*) FROM Fact_Acct WHERE Account_ID=?";
            int no = DB.getSQLValue(this.get_TrxName(), sql, this.getC_ElementValue_ID());
            if (no != 0) {
                this.log.saveError("Error", "Already posted to");
                return false;
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && (this.is_ValueChanged("Value") || this.is_ValueChanged("Name"))) {
            MAccount.updateValueDescription(this.getCtx(), "Account_ID=" + this.getC_ElementValue_ID(), this.get_TrxName());
            if ("Y".equals(this.getCtx().getContext("$Element_U1"))) {
                MAccount.updateValueDescription(this.getCtx(), "User1_ID=" + this.getC_ElementValue_ID(), this.get_TrxName());
            }
            if ("Y".equals(this.getCtx().getContext("$Element_U2"))) {
                MAccount.updateValueDescription(this.getCtx(), "User2_ID=" + this.getC_ElementValue_ID(), this.get_TrxName());
            }
        }
        return success;
    }
}

