/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MIssue;
import org.compiere.model.X_R_IssueSystem;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MIssueSystem
extends X_R_IssueSystem {
    private static CLogger s_log = CLogger.getCLogger(MIssueSystem.class);

    public static MIssueSystem get(MIssue issue) {
        if (issue.getDBAddress() == null) {
            return null;
        }
        X_R_IssueSystem system = null;
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM R_IssueSystem WHERE DBAddress=?";
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, issue.getDBAddress());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                system = new MIssueSystem(issue.getCtx(), rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (system == null) {
            system = new MIssueSystem(issue.getCtx(), 0, null);
            system.setDBAddress(issue.getDBAddress());
            system.setA_Asset_ID(issue.getA_Asset_ID());
        }
        system.setSystemStatus(issue.getSystemStatus());
        system.setStatisticsInfo(issue.getStatisticsInfo());
        system.setProfileInfo(issue.getProfileInfo());
        if (issue.getA_Asset_ID() != 0 && system.getA_Asset_ID() != issue.getA_Asset_ID()) {
            system.setA_Asset_ID(issue.getA_Asset_ID());
        }
        if (!system.save()) {
            return null;
        }
        issue.setR_IssueSystem_ID(system.getR_IssueSystem_ID());
        if (system.getA_Asset_ID() != 0) {
            issue.setA_Asset_ID(system.getA_Asset_ID());
        }
        return system;
    }

    public MIssueSystem(Ctx ctx, int R_IssueSystem_ID, String trxName) {
        super(ctx, R_IssueSystem_ID, trxName);
    }

    public MIssueSystem(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MIssueSystem[");
        sb.append(this.get_ID()).append("-").append(this.getDBAddress()).append(",A_Asset_ID=").append(this.getA_Asset_ID()).append("]");
        return sb.toString();
    }
}

