/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.X_AD_MigrationStep;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MMigrationStep
extends X_AD_MigrationStep {
    public MMigrationStep(Ctx ctx, int AD_MigrationStep_ID, String trxName) {
        super(ctx, AD_MigrationStep_ID, trxName);
        if (AD_MigrationStep_ID == 0) {
            this.setIsOkToFail(true);
            this.setSeqNo(0);
            this.setTimingType("3");
            this.setType("S");
        }
    }

    public MMigrationStep(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String execute() {
        String type = this.getType();
        if (type.equals("J")) {
            return this.executeJava();
        }
        if (type.equals("E")) {
            return this.executeJavaScript();
        }
        if (type.equals("S")) {
            return this.executeSQL();
        }
        return "Invalid Step: " + this.toString();
    }

    private String executeJava() {
        String classMethodName = this.getClassname();
        if (classMethodName == null || classMethodName.length() == 0) {
            return "No ClassName: " + this.toString();
        }
        return "Not Implemented Yet (Java)";
    }

    private String executeJavaScript() {
        String code = this.getCode();
        if (code == null || code.length() == 0) {
            return "No Code: " + this.toString();
        }
        return "Not Implemented Yet (JavaScript)";
    }

    private String executeSQL() {
        if (!this.isActive()) {
            return null;
        }
        String code = this.getCode();
        if (code == null || code.length() == 0) {
            return "No Code: " + this.toString();
        }
        String error = null;
        StringTokenizer st = new StringTokenizer(code, ";");
        while (st.hasMoreTokens() && (error = this.executeSQL(st.nextToken())) == null) {
        }
        return error;
    }

    private String executeSQL(String sql) {
        String error = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            int no = pstmt.executeUpdate();
            this.log.finer("#" + no + " - " + this.getName());
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            error = e.getLocalizedMessage();
            if (error == null) {
                error = e.toString();
            }
            this.log.log(Level.WARNING, sql + " - " + error);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return error;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MMigrationStep[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

