/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MMenu;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcessAccess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MRole;
import org.compiere.model.MWindow;
import org.compiere.model.X_AD_Process;
import org.compiere.model.X_AD_WF_Node;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Trx;

public class MProcess
extends X_AD_Process {
    private static CCache<Integer, MProcess> s_cache = new CCache("AD_Process", 20);
    private static CLogger s_log = CLogger.getCLogger(MProcess.class);
    private MProcessPara[] m_parameters = null;

    public static MProcess get(Ctx ctx, int AD_Process_ID) {
        Integer key = new Integer(AD_Process_ID);
        MProcess retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProcess(ctx, AD_Process_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MProcess getByValue(Ctx ctx, String value) {
        MProcess retValue = null;
        String sql = "SELECT * FROM AD_Process p WHERE p.Value LIKE ?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, value);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProcess(ctx, rs, null);
                Integer key = new Integer(retValue.getAD_Process_ID());
                s_cache.put(key, retValue);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MProcess getFromMenu(Ctx ctx, int AD_Menu_ID) {
        MProcess retValue = null;
        String sql = "SELECT * FROM AD_Process p WHERE EXISTS (SELECT * FROM AD_Menu m WHERE m.AD_Process_ID=p.AD_Process_ID AND m.AD_Menu_ID=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Menu_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MProcess(ctx, rs, null);
                Integer key = new Integer(retValue.getAD_Process_ID());
                s_cache.put(key, retValue);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MProcess(Ctx ctx, int AD_Process_ID, String ignored) {
        super(ctx, AD_Process_ID, null);
        if (AD_Process_ID == 0) {
            this.setIsReport(false);
            this.setIsServerProcess(false);
            this.setAccessLevel("7");
            this.setEntityType("U");
            this.setIsBetaFunctionality(false);
        }
    }

    public MProcess(Ctx ctx, ResultSet rs, String ignored) {
        super(ctx, rs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MProcessPara[] getParameters() {
        if (this.m_parameters != null) {
            return this.m_parameters;
        }
        ArrayList<MProcessPara> list = new ArrayList<MProcessPara>();
        String sql = "SELECT * FROM AD_Process_Para WHERE AD_Process_ID=? ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.getAD_Process_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MProcessPara(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_parameters = new MProcessPara[list.size()];
        list.toArray(this.m_parameters);
        return this.m_parameters;
    }

    public MProcessPara getParameter(String name) {
        this.getParameters();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            if (!this.m_parameters[i].getColumnName().equals(name)) continue;
            return this.m_parameters[i];
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProcess[").append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public MPInstance processIt(int Record_ID) {
        MPInstance pInstance = new MPInstance(this, Record_ID);
        pInstance.setIsProcessing(true);
        pInstance.save();
        boolean ok = true;
        String ProcedureName = this.getProcedureName();
        if (ProcedureName != null && ProcedureName.length() > 0) {
            ok = this.startProcess(ProcedureName, pInstance);
        }
        pInstance.setResult(ok ? 1 : 0);
        pInstance.setIsProcessing(false);
        pInstance.save();
        pInstance.log();
        return pInstance;
    }

    public boolean processIt(ProcessInfo pi, Trx trx) {
        if (pi.getAD_PInstance_ID() == 0) {
            MPInstance pInstance = new MPInstance(this, pi.getRecord_ID());
            pInstance.setIsProcessing(true);
            pInstance.save();
        }
        boolean ok = false;
        String Classname = this.getClassname();
        if (Classname != null && Classname.length() > 0) {
            ok = this.startClass(Classname, pi, trx);
        } else {
            String msg = "No Classname for " + this.getName();
            pi.setSummary(msg, ok);
            this.log.warning(msg);
        }
        return ok;
    }

    public boolean isJavaProcess() {
        String Classname = this.getClassname();
        return Classname != null && Classname.length() > 0;
    }

    private boolean startProcess(String ProcedureName, MPInstance pInstance) {
        int AD_PInstance_ID = pInstance.getAD_PInstance_ID();
        this.log.info(ProcedureName + "(" + AD_PInstance_ID + ")");
        String sql = "{call " + ProcedureName + "(?)}";
        try {
            CallableStatement cstmt = DB.prepareCall(sql);
            cstmt.setInt(1, AD_PInstance_ID);
            cstmt.executeUpdate();
            cstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            pInstance.setResult(0);
            pInstance.setErrorMsg(e.getLocalizedMessage());
            return false;
        }
        pInstance.setResult(1);
        return true;
    }

    private boolean startClass(String Classname, ProcessInfo pi, Trx trx) {
        this.log.info(Classname + "(" + pi + ")");
        boolean retValue = false;
        ProcessCall myObject = null;
        try {
            Class<?> myClass = Class.forName(Classname);
            myObject = (ProcessCall)myClass.newInstance();
            retValue = myObject == null ? false : myObject.startProcess(this.getCtx(), pi, trx);
        }
        catch (Exception e) {
            pi.setSummary("Error Start Class " + Classname, true);
            this.log.log(Level.SEVERE, Classname, e);
            throw new RuntimeException(e);
        }
        return retValue;
    }

    public boolean isWorkflow() {
        return this.getAD_Workflow_ID() > 0;
    }

    public void addStatistics(int seconds) {
        this.setStatistic_Count(this.getStatistic_Count() + 1);
        this.setStatistic_Seconds(this.getStatistic_Seconds().add(new BigDecimal(seconds)));
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        block6: {
            block5: {
                if (!newRecord) break block5;
                MRole[] roles = MRole.getOf(this.getCtx(), "IsManual='N'");
                for (int i = 0; i < roles.length; ++i) {
                    MProcessAccess pa = new MProcessAccess(this, roles[i].getAD_Role_ID());
                    pa.save();
                }
                break block6;
            }
            if (!this.is_ValueChanged("IsActive") && !this.is_ValueChanged("Name") && !this.is_ValueChanged("Description") && !this.is_ValueChanged("Help")) break block6;
            MMenu[] menues = MMenu.get(this.getCtx(), "AD_Process_ID=" + this.getAD_Process_ID());
            for (int i = 0; i < menues.length; ++i) {
                menues[i].setIsActive(this.isActive());
                menues[i].setName(this.getName());
                menues[i].setDescription(this.getDescription());
                menues[i].save();
            }
            X_AD_WF_Node[] nodes = MWindow.getWFNodes(this.getCtx(), "AD_Process_ID=" + this.getAD_Process_ID());
            for (int i = 0; i < nodes.length; ++i) {
                boolean changed = false;
                if (nodes[i].isActive() != this.isActive()) {
                    nodes[i].setIsActive(this.isActive());
                    changed = true;
                }
                if (nodes[i].isCentrallyMaintained()) {
                    nodes[i].setName(this.getName());
                    nodes[i].setDescription(this.getDescription());
                    nodes[i].setHelp(this.getHelp());
                    changed = true;
                }
                if (!changed) continue;
                nodes[i].save();
            }
        }
        return success;
    }
}

