/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.framework.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.X_AD_Process_Para;
import org.compiere.util.CCache;
import org.compiere.util.Ctx;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class MProcessPara
extends X_AD_Process_Para {
    private static CCache<Integer, MProcessPara> s_cache = new CCache("AD_Process_Para", 20);
    public static int WINDOW_NO = 999;
    public static int TAB_NO = 0;
    private Lookup m_lookup = null;

    public static MProcessPara get(Ctx ctx, int AD_Process_Para_ID) {
        Integer key = new Integer(AD_Process_Para_ID);
        MProcessPara retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProcessPara(ctx, AD_Process_Para_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MProcessPara(Ctx ctx, int AD_Process_Para_ID, String trxName) {
        super(ctx, AD_Process_Para_ID, trxName);
        if (AD_Process_Para_ID == 0) {
            this.setFieldLength(0);
            this.setSeqNo(0);
            this.setIsCentrallyMaintained(true);
            this.setIsRange(false);
            this.setIsMandatory(false);
            this.setEntityType("U");
        }
    }

    public MProcessPara(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isLookup() {
        boolean retValue = false;
        int displayType = this.getAD_Reference_ID();
        if (DisplayType.isLookup((int)displayType)) {
            retValue = true;
        } else if (displayType == 21 || displayType == 31 || displayType == 25 || displayType == 35) {
            retValue = true;
        }
        return retValue;
    }

    public void loadLookup() {
        if (!this.isLookup()) {
            return;
        }
        this.log.fine("(" + this.getColumnName() + ")");
        int displayType = this.getAD_Reference_ID();
        if (DisplayType.isLookup((int)displayType)) {
            MLookup ml = new MLookup(this.getCtx(), 0, this.getAD_Reference_ID());
            MLookupInfo lookupInfo = MLookupFactory.getLookupInfo(ml, this.getAD_Process_Para_ID(), Env.getLanguage(this.getCtx()), this.getColumnName(), this.getAD_Reference_Value_ID(), false, "");
            if (lookupInfo == null) {
                this.log.log(Level.SEVERE, "(" + this.getColumnName() + ") - No LookupInfo");
                return;
            }
            if (displayType == 18 && (this.getColumnName().equals("CreatedBy") || this.getColumnName().equals("UpdatedBy"))) {
                lookupInfo.IsCreadedUpdatedBy = true;
                ml.setDisplayType(30);
            }
            this.m_lookup = ml.initialize(lookupInfo);
        } else if (displayType == 21) {
            MLocationLookup ml = new MLocationLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = ml;
        } else if (displayType == 31) {
            MLocatorLookup ml = new MLocatorLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = ml;
        } else if (displayType == 25) {
            MAccountLookup ma = new MAccountLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = ma;
        } else if (displayType == 35) {
            MPAttributeLookup pa = new MPAttributeLookup(this.getCtx(), WINDOW_NO);
            this.m_lookup = pa;
        }
        if (this.m_lookup != null) {
            this.m_lookup.loadComplete();
        }
    }

    public Lookup getLookup() {
        if (this.m_lookup == null && this.isLookup()) {
            this.loadLookup();
        }
        return this.m_lookup;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MProcessPara[").append(this.get_ID()).append("]");
        return sb.toString();
    }
}

