/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNodeCMS;
import org.compiere.model.X_AD_TreeNodeCMT;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MTreeNodeCMT
extends X_AD_TreeNodeCMT {
    private static CLogger s_log = CLogger.getCLogger(MTreeNodeCMS.class);

    public static MTreeNodeCMT[] getTree(Ctx ctx, int AD_Tree_ID, String trxName) {
        ArrayList<MTreeNodeCMT> list = new ArrayList<MTreeNodeCMT>();
        String sql = "SELECT * FROM AD_TreeNodeCMT WHERE AD_Tree_ID=? ORDER BY Node_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Tree_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MTreeNodeCMT(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MTreeNodeCMT[] retValue = new MTreeNodeCMT[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MTreeNodeCMT get(MTree tree, int Node_ID) {
        MTreeNodeCMT retValue = null;
        String sql = "SELECT * FROM AD_TreeNodeCMT WHERE AD_Tree_ID=? AND Node_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, tree.get_TrxName());
            pstmt.setInt(1, tree.getAD_Tree_ID());
            pstmt.setInt(2, Node_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MTreeNodeCMT(tree.getCtx(), rs, tree.get_TrxName());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MTreeNodeCMT(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTreeNodeCMT(MTree tree, int Node_ID) {
        super(tree.getCtx(), 0, tree.get_TrxName());
        this.setClientOrg(tree);
        this.setAD_Tree_ID(tree.getAD_Tree_ID());
        this.setNode_ID(Node_ID);
        this.setParent_ID(0);
        this.setSeqNo(0);
    }
}

