/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CompiereBorders {
    public static final Color fc = Color.red;

    public static Border getTextFieldBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new MetalBorders.TextFieldBorder(), new MarginBorder());
    }

    public static Border getButtonBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource buttonBorder = new BorderUIResource.CompoundBorderUIResource(new BasicBorders.ButtonBorder(table.getColor("Button.shadow"), table.getColor("Button.darkShadow"), table.getColor("Button.light"), table.getColor("Button.highlight")), new MarginBorder());
        return buttonBorder;
    }

    static void drawPressed3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        CompiereBorders.drawFlush3DBorder(g, 0, 0, w, h);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawLine(1, 1, 1, h - 2);
        g.drawLine(1, 1, w - 2, 1);
        g.translate(-x, -y);
    }

    static void drawFlush3DBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlDarkShadow());
        g.drawRect(0, 0, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControlHighlight());
        g.drawRect(1, 1, w - 2, h - 2);
        g.setColor(MetalLookAndFeel.getControl());
        g.drawLine(0, h - 1, 1, h - 2);
        g.drawLine(w - 1, 0, w - 2, 1);
        g.translate(-x, -y);
    }

    public static class CheckBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        protected int getControlSize() {
            return 13;
        }

        private void paintOceanIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            g.translate(x, y);
            int w = this.getIconWidth();
            int h = this.getIconHeight();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(0, 0, w, h);
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.fillRect(0, 0, w, 2);
                    g.fillRect(0, 2, 2, h - 2);
                    g.fillRect(w - 1, 1, 1, h - 1);
                    g.fillRect(1, h - 1, w - 2, 1);
                } else if (model.isRollover()) {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.setColor(MetalLookAndFeel.getPrimaryControl());
                    g.drawRect(1, 1, w - 3, h - 3);
                    g.drawRect(2, 2, w - 5, h - 5);
                } else {
                    g.setColor(MetalLookAndFeel.getControlDarkShadow());
                    g.drawRect(0, 0, w - 1, h - 1);
                }
                if (cb.hasFocus()) {
                    g.setColor(fc);
                    g.drawRect(0, 0, w, h);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
                g.drawRect(0, 0, w - 1, h - 1);
            }
            g.translate(-x, -y);
            if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JCheckBox cb = (JCheckBox)c;
            ButtonModel model = cb.getModel();
            int controlSize = this.getControlSize();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    g.setColor(MetalLookAndFeel.getControlShadow());
                    g.fillRect(x, y, controlSize - 1, controlSize - 1);
                    CompiereBorders.drawPressed3DBorder(g, x, y, controlSize, controlSize);
                } else {
                    CompiereBorders.drawFlush3DBorder(g, x, y, controlSize, controlSize);
                }
                if (cb.hasFocus()) {
                    g.translate(x, y);
                    g.setColor(fc);
                    g.drawRect(0, 0, controlSize - 1, controlSize - 1);
                    g.translate(-x, -y);
                }
                g.setColor(MetalLookAndFeel.getControlInfo());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, controlSize - 2, controlSize - 2);
            }
            if (model.isSelected()) {
                this.drawCheck(c, g, x, y);
            }
        }

        protected void drawCheck(Component c, Graphics g, int x, int y) {
            int controlSize = this.getControlSize();
            g.fillRect(x + 3, y + 5, 2, controlSize - 8);
            g.drawLine(x + (controlSize - 4), y + 3, x + 5, y + (controlSize - 6));
            g.drawLine(x + (controlSize - 4), y + 4, x + 5, y + (controlSize - 5));
        }

        public int getIconWidth() {
            return this.getControlSize();
        }

        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder {
        protected static Insets editorBorderInsets = new Insets(2, 2, 2, 0);
        private static final Insets SAFE_EDITOR_BORDER_INSETS = new Insets(2, 2, 2, 0);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(0, h - 2, w - 1, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(1, 1, w - 1, 1);
            g.drawLine(1, 1, 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(1, h - 2, 1, h - 2);
            if (c.hasFocus()) {
                g.setColor(fc);
                g.drawLine(0, 0, w, 0);
                g.drawLine(0, h - 2, w, h - 2);
            }
            g.translate(-x, -y);
        }

        public Insets getBorderInsets(Component c) {
            if (System.getSecurityManager() != null) {
                return SAFE_EDITOR_BORDER_INSETS;
            }
            return editorBorderInsets;
        }
    }

    public static class MarginBorder
    extends BasicBorders.MarginBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (c.hasFocus()) {
                g.translate(x, y);
                g.setColor(fc);
                g.drawLine(0, 0, w, 0);
                g.drawLine(0, h, w, h);
                g.translate(-x, -y);
            }
        }
    }
}

