/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import org.compiere.plaf.CompiereColor;
import org.compiere.plaf.CompierePLAF;
import org.compiere.plaf.CompierePanelUI;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.KeyNamePair;
import org.compiere.util.ValueNamePair;

public class CompiereColorEditor
extends CDialog
implements ActionListener,
PropertyEditor {
    private static ResourceBundle res = ResourceBundle.getBundle("org.compiere.translate.PlafRes");
    private CompiereColor m_cc = null;
    private boolean m_saved = false;
    private boolean m_setting = false;
    private CPanel northPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private CButton bOK = CompierePLAF.getOKButton();
    private CButton bCancel = CompierePLAF.getCancelButton();
    private FlowLayout southLayout = new FlowLayout();
    private GridBagLayout northLayout = new GridBagLayout();
    private CLabel typeLabel = new CLabel();
    private CComboBox typeField = new CComboBox(CompiereColor.TYPES);
    private CButton gradientUpper = new CButton();
    private CButton gradientLower = new CButton();
    private CLabel urlLabel = new CLabel();
    private CTextField urlField = new CTextField(30);
    private CLabel alphaLabel = new CLabel();
    private CTextField alphaField = new CTextField(10);
    private CButton taintColor = new CButton();
    private CButton lineColor = new CButton();
    private CButton backColor = new CButton();
    private CLabel widthLabel = new CLabel();
    private CTextField widthField = new CTextField(10);
    private CLabel distanceLabel = new CLabel();
    private CTextField distanceField = new CTextField(10);
    private CPanel centerPanel = new CPanel();
    private CButton flatField = new CButton();
    private CComboBox gradientStartField = new CComboBox(CompiereColor.GRADIENT_SP);
    private CTextField gradientDistanceField = new CTextField(10);
    private CLabel gradientStartLabel = new CLabel();
    private CLabel gradientDistanceLabel = new CLabel();

    public static CompiereColor showDialog(Frame owner, CompiereColor color) {
        CompiereColorEditor cce = new CompiereColorEditor(owner, color);
        if (cce.isSaved()) {
            return cce.getColor();
        }
        return color;
    }

    public static CompiereColor showDialog(Dialog owner, CompiereColor color) {
        CompiereColorEditor cce = new CompiereColorEditor(owner, color);
        if (cce.isSaved()) {
            return cce.getColor();
        }
        return color;
    }

    public CompiereColorEditor(Frame owner, CompiereColor color) {
        super(owner, "", true);
        this.init(color);
    }

    public CompiereColorEditor(Dialog owner, CompiereColor color) {
        super(owner, "", true);
        this.init(color);
    }

    private void init(CompiereColor color) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.typeField.addActionListener(this);
        this.flatField.addActionListener(this);
        this.gradientUpper.addActionListener(this);
        this.gradientLower.addActionListener(this);
        this.urlField.addActionListener(this);
        this.alphaField.addActionListener(this);
        this.taintColor.addActionListener(this);
        this.lineColor.addActionListener(this);
        this.backColor.addActionListener(this);
        this.widthField.addActionListener(this);
        this.distanceField.addActionListener(this);
        this.gradientStartField.addActionListener(this);
        this.gradientDistanceField.addActionListener(this);
        if (color == null) {
            this.setColor(this.m_cc);
        } else {
            this.setColor(new CompiereColor(color));
        }
        CompierePLAF.showCenterScreen(this);
    }

    private void jbInit() throws Exception {
        this.setTitle(res.getString("CompiereColorEditor"));
        this.southPanel.setLayout(this.southLayout);
        this.southLayout.setAlignment(2);
        this.northPanel.setLayout(this.northLayout);
        this.typeLabel.setText(res.getString("CompiereType"));
        this.gradientUpper.setText(res.getString("GradientUpperColor"));
        this.gradientLower.setText(res.getString("GradientLowerColor"));
        this.gradientStartLabel.setText(res.getString("GradientStart"));
        this.gradientDistanceLabel.setText(res.getString("GradientDistance"));
        this.urlLabel.setText(res.getString("TextureURL"));
        this.alphaLabel.setText(res.getString("TextureAlpha"));
        this.taintColor.setText(res.getString("TextureTaintColor"));
        this.lineColor.setText(res.getString("LineColor"));
        this.backColor.setText(res.getString("LineBackColor"));
        this.widthLabel.setText(res.getString("LineWidth"));
        this.distanceLabel.setText(res.getString("LineDistance"));
        this.flatField.setText(res.getString("FlatColor"));
        this.centerPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.centerPanel.setPreferredSize(new Dimension(400, 200));
        this.centerPanel.setOpaque(true);
        this.northPanel.setPreferredSize(new Dimension(400, 150));
        this.southPanel.add((Component)this.bCancel, null);
        this.getContentPane().add((Component)this.northPanel, "North");
        this.southPanel.add((Component)this.bOK, null);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.northPanel.add((Component)this.typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.typeField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.northPanel.add((Component)this.gradientLower, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.urlField, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.alphaLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.alphaField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.taintColor, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.backColor, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.widthLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.widthField, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.distanceLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.distanceField, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.flatField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.gradientStartField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.gradientDistanceField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.urlLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.gradientStartLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.gradientDistanceLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.gradientUpper, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.lineColor, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_setting) {
            return;
        }
        if (e.getSource() == this.bOK) {
            this.m_saved = true;
            this.dispose();
            return;
        }
        if (e.getSource() == this.bCancel) {
            this.dispose();
            return;
        }
        try {
            if (e.getSource() == this.typeField) {
                this.cmd_type();
            } else if (e.getSource() == this.flatField) {
                this.m_cc.setFlatColor(JColorChooser.showDialog(this, this.flatField.getText(), this.m_cc.getFlatColor()));
            } else if (e.getSource() == this.gradientUpper) {
                this.m_cc.setGradientUpperColor(JColorChooser.showDialog(this, this.gradientUpper.getText(), this.m_cc.getGradientUpperColor()));
            } else if (e.getSource() == this.gradientLower) {
                this.m_cc.setGradientLowerColor(JColorChooser.showDialog(this, this.gradientLower.getText(), this.m_cc.getGradientLowerColor()));
            } else if (e.getSource() == this.gradientStartField) {
                this.m_cc.setGradientStartPoint(((KeyNamePair)this.gradientStartField.getSelectedItem()).getKey());
            } else if (e.getSource() == this.gradientDistanceField) {
                this.m_cc.setGradientRepeatDistance(this.gradientDistanceField.getText());
            } else if (e.getSource() == this.urlField) {
                this.m_cc.setTextureURL(this.urlField.getText());
            } else if (e.getSource() == this.alphaField) {
                this.m_cc.setTextureCompositeAlpha(this.alphaField.getText());
            } else if (e.getSource() == this.taintColor) {
                this.m_cc.setTextureTaintColor(JColorChooser.showDialog(this, this.taintColor.getText(), this.m_cc.getTextureTaintColor()));
            } else if (e.getSource() == this.lineColor) {
                this.m_cc.setLineColor(JColorChooser.showDialog(this, this.lineColor.getText(), this.m_cc.getLineColor()));
            } else if (e.getSource() == this.backColor) {
                this.m_cc.setLineBackColor(JColorChooser.showDialog(this, this.backColor.getText(), this.m_cc.getLineBackColor()));
            } else if (e.getSource() == this.widthField) {
                this.m_cc.setLineWidth(this.widthField.getText());
            } else if (e.getSource() == this.distanceField) {
                this.m_cc.setLineDistance(this.distanceField.getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColor(this.m_cc);
    }

    private void cmd_type() {
        ValueNamePair vp = (ValueNamePair)this.typeField.getSelectedItem();
        if (vp.getValue().equals("F")) {
            this.m_cc = new CompiereColor("F");
        } else if (vp.getValue().equals("G")) {
            this.m_cc = new CompiereColor("G");
        } else if (vp.getValue().equals("T")) {
            this.m_cc = new CompiereColor("T");
        } else if (vp.getValue().equals("L")) {
            this.m_cc = new CompiereColor("L");
        }
        this.setColor(this.m_cc);
    }

    public void setColor(CompiereColor color) {
        if (color == null && this.m_cc != null) {
            return;
        }
        this.m_cc = color;
        if (this.m_cc == null) {
            this.m_cc = CompierePanelUI.getDefaultBackground();
        }
        this.updateFields();
        this.centerPanel.setBackgroundColor(this.m_cc);
        this.centerPanel.repaint();
    }

    private void updateFields() {
        int i;
        this.m_setting = true;
        for (i = 0; i < CompiereColor.TYPES.length; ++i) {
            if (!this.m_cc.getType().equals(CompiereColor.TYPE_VALUES[i])) continue;
            this.typeField.setSelectedItem(CompiereColor.TYPES[i]);
            break;
        }
        if (this.m_cc.isFlat()) {
            this.flatField.setVisible(true);
            this.gradientUpper.setVisible(false);
            this.gradientLower.setVisible(false);
            this.gradientStartLabel.setVisible(false);
            this.gradientDistanceLabel.setVisible(false);
            this.gradientStartField.setVisible(false);
            this.gradientDistanceField.setVisible(false);
            this.urlLabel.setVisible(false);
            this.urlField.setVisible(false);
            this.alphaLabel.setVisible(false);
            this.alphaField.setVisible(false);
            this.taintColor.setVisible(false);
            this.lineColor.setVisible(false);
            this.backColor.setVisible(false);
            this.widthLabel.setVisible(false);
            this.widthField.setVisible(false);
            this.distanceLabel.setVisible(false);
            this.distanceField.setVisible(false);
            this.flatField.setBackground(this.m_cc.getFlatColor());
        } else if (this.m_cc.isGradient()) {
            this.flatField.setVisible(false);
            this.gradientUpper.setVisible(true);
            this.gradientLower.setVisible(true);
            this.gradientStartLabel.setVisible(true);
            this.gradientDistanceLabel.setVisible(true);
            this.gradientStartField.setVisible(true);
            this.gradientDistanceField.setVisible(true);
            this.urlLabel.setVisible(false);
            this.urlField.setVisible(false);
            this.alphaLabel.setVisible(false);
            this.alphaField.setVisible(false);
            this.taintColor.setVisible(false);
            this.lineColor.setVisible(false);
            this.backColor.setVisible(false);
            this.widthLabel.setVisible(false);
            this.widthField.setVisible(false);
            this.distanceLabel.setVisible(false);
            this.distanceField.setVisible(false);
            this.gradientUpper.setBackground(this.m_cc.getGradientUpperColor());
            this.gradientLower.setBackground(this.m_cc.getGradientLowerColor());
            this.gradientDistanceField.setText(String.valueOf(this.m_cc.getGradientRepeatDistance()));
            for (i = 0; i < CompiereColor.GRADIENT_SP.length; ++i) {
                if (this.m_cc.getGradientStartPoint() != CompiereColor.GRADIENT_SP_VALUES[i]) continue;
                this.gradientStartField.setSelectedItem(CompiereColor.GRADIENT_SP[i]);
                break;
            }
        } else if (this.m_cc.isTexture()) {
            this.flatField.setVisible(false);
            this.gradientUpper.setVisible(false);
            this.gradientLower.setVisible(false);
            this.gradientStartLabel.setVisible(false);
            this.gradientDistanceLabel.setVisible(false);
            this.gradientStartField.setVisible(false);
            this.gradientDistanceField.setVisible(false);
            this.urlLabel.setVisible(true);
            this.urlField.setVisible(true);
            this.alphaLabel.setVisible(true);
            this.alphaField.setVisible(true);
            this.taintColor.setVisible(true);
            this.lineColor.setVisible(false);
            this.backColor.setVisible(false);
            this.widthLabel.setVisible(false);
            this.widthField.setVisible(false);
            this.distanceLabel.setVisible(false);
            this.distanceField.setVisible(false);
            this.urlField.setText(this.m_cc.getTextureURL().toString());
            this.alphaField.setText(String.valueOf(this.m_cc.getTextureCompositeAlpha()));
            this.taintColor.setBackground(this.m_cc.getTextureTaintColor());
        } else if (this.m_cc.isLine()) {
            this.flatField.setVisible(false);
            this.gradientUpper.setVisible(false);
            this.gradientLower.setVisible(false);
            this.gradientStartLabel.setVisible(false);
            this.gradientDistanceLabel.setVisible(false);
            this.gradientStartField.setVisible(false);
            this.gradientDistanceField.setVisible(false);
            this.urlLabel.setVisible(false);
            this.urlField.setVisible(false);
            this.alphaLabel.setVisible(false);
            this.alphaField.setVisible(false);
            this.taintColor.setVisible(false);
            this.lineColor.setVisible(true);
            this.backColor.setVisible(true);
            this.widthLabel.setVisible(true);
            this.widthField.setVisible(true);
            this.distanceLabel.setVisible(true);
            this.distanceField.setVisible(true);
            this.lineColor.setBackground(this.m_cc.getLineColor());
            this.backColor.setBackground(this.m_cc.getLineBackColor());
            this.widthField.setText(String.valueOf(this.m_cc.getLineWidth()));
            this.distanceField.setText(String.valueOf(this.m_cc.getLineDistance()));
        }
        this.m_setting = false;
    }

    public CompiereColor getColor() {
        return this.m_cc;
    }

    public boolean isSaved() {
        return this.m_saved;
    }

    public void setValue(Object value) {
        if (value == null || !(value instanceof CompiereColor)) {
            throw new IllegalArgumentException("CompiereColorEditor.setValue requires CompiereColor");
        }
        this.setColor(new CompiereColor((CompiereColor)value));
    }

    public Object getValue() {
        return this.getColor();
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        throw new UnsupportedOperationException("Method paintValue() not yet implemented.");
    }

    public String getJavaInitializationString() {
        return "new CompiereColor()";
    }

    public String getAsText() {
        return this.m_cc.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException("CompiereColorEditor.setAsText not supported");
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
    }
}

